/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.accesspoint.AccessPointModel;
import at.mrdevelopment.esl.provisioning.ClaimId;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;

public abstract class DefaultSystemAttributes
implements SystemAttributes {
    private static final String SYSTEM_ID = "system.id";
    private static final String SYSTEM_SERIAL = "system.serial";
    private static final String SYSTEM_REVISION = "system.revision";
    private static final String SYSTEM_MODE = "system.mode";
    private static final String PROVISIONING_CLAIM_ID = "system.provisioning.claimid";
    private final PlatformStorage storage;
    private int id;
    private String serial;
    private int revision;
    private DeviceMode mode;
    private ClaimId claimId;
    private final boolean failOnMissingId;
    private final DeviceMode defaultDeviceMode;

    public DefaultSystemAttributes(PlatformStorage storage, boolean failOnMissingId, DeviceMode defaultDeviceMode) throws SerializeException, InitializationException {
        this.storage = storage;
        this.failOnMissingId = failOnMissingId;
        this.defaultDeviceMode = defaultDeviceMode;
        this.claimId = this.loadOrCreateClaimId();
        this.reload();
    }

    private ClaimId loadOrCreateClaimId() throws SerializeException {
        String claimIdString = this.load(PROVISIONING_CLAIM_ID, String.class);
        ClaimId claimId = null;
        if (claimIdString == null) {
            claimId = ClaimId.generateRandomClaimId();
            this.save(PROVISIONING_CLAIM_ID, claimId.getClaimIdString());
        } else {
            claimId = ClaimId.fromString(claimIdString);
        }
        return claimId;
    }

    @Override
    public void reload() throws SerializeException, InitializationException {
        this.loadId(this.failOnMissingId);
        this.loadSerial();
        this.loadRevision();
        this.loadDeviceMode(this.defaultDeviceMode);
    }

    @Override
    public synchronized int getId() {
        return this.id;
    }

    @Override
    public synchronized String getSerial() {
        return this.serial;
    }

    @Override
    public synchronized int getRevision() {
        return this.revision;
    }

    @Override
    public synchronized DeviceMode getDeviceMode() {
        return this.mode;
    }

    @Override
    public synchronized void setId(int id) throws SerializeException {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_ID, id);
        this.id = id;
    }

    @Override
    public synchronized void setSerial(String serial) throws SerializeException {
        if (serial == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_SERIAL, serial);
        this.serial = serial;
    }

    @Override
    public synchronized void setRevision(int revision) throws SerializeException {
        if (revision < 0) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_REVISION, revision);
        this.revision = revision;
    }

    @Override
    public void setDeviceMode(DeviceMode mode) throws Exception {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_MODE, (Object)mode);
        this.mode = mode;
    }

    private void loadId(boolean failOnMissingId) throws SerializeException, InitializationException {
        Integer id = this.load(SYSTEM_ID, Integer.class);
        if (id == null && failOnMissingId) {
            throw new InitializationException("No device ID specified", new Object[0]);
        }
        this.id = id != null ? id : 0;
    }

    private void loadSerial() throws SerializeException {
        String serial = this.load(SYSTEM_SERIAL, String.class);
        this.serial = serial != null ? serial : "";
    }

    private void loadRevision() throws SerializeException {
        Integer revision = this.load(SYSTEM_REVISION, Integer.class);
        this.revision = revision != null ? revision : 0;
    }

    private void loadDeviceMode(DeviceMode defaultDeviceMode) throws SerializeException {
        DeviceMode mode = this.load(SYSTEM_MODE, DeviceMode.class);
        if (mode == null) {
            mode = defaultDeviceMode;
        }
        this.mode = mode;
    }

    protected void save(String key, Object value) throws SerializeException {
        this.storage.storeKey(key, value != null ? value.toString() : null);
    }

    protected <T> T load(String key, Class<T> type) throws SerializeException {
        String value = this.storage.queryKey(key);
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
            if (type == Password.class) {
                return type.cast(new Password(value));
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(value));
            }
            if (type == DeviceMode.class) {
                return type.cast((Object)DeviceMode.valueOf(value));
            }
            if (type == Long.class) {
                return type.cast(Long.valueOf(value));
            }
            if (type == AccessPointModel.class) {
                return type.cast((Object)AccessPointModel.getFrom(value));
            }
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc, "Failed to parse storage key %s", new Object[]{key});
        }
        throw new SerializeException("Unsupported storage type %s for key %s", new Object[]{type.getName(), key});
    }

    @Override
    public ClaimId getClaimId() {
        return this.claimId;
    }

    @Override
    public void setClaimId(String claimId) throws Exception {
        this.claimId = ClaimId.fromString(claimId);
        this.save(PROVISIONING_CLAIM_ID, this.claimId.getClaimIdString());
    }
}

