/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.DefaultSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.accesspoint.AccessPointModel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class DefaultAccessPointSystemAttributes
extends DefaultSystemAttributes
implements AccessPointSystemAttributes {
    private static final String DEVICE_NAME_AP_2020 = "SES-imagotag Access Point AP-2020";
    private static final String SYSTEM_PASSWORD = "system.password";
    private static final String SYSTEM_DEFAULT_PASSWORD = "system.default.password";
    private static final String SYSTEM_FORBID_JOIN = "system.forbid-join";
    private static final String SYSTEM_MODEL = "system.model";
    private Password password;
    private Password defaultPassword;
    private boolean forbidJoin;
    private AccessPointModel deviceModel;

    public DefaultAccessPointSystemAttributes(PlatformStorage storage, boolean failOnMissingAccessPointId, DeviceMode defaultDeviceMode) throws SerializeException, InitializationException {
        super(storage, failOnMissingAccessPointId, defaultDeviceMode);
    }

    @Override
    public void reload() throws SerializeException, InitializationException {
        super.reload();
        this.loadPassword();
        this.loadDefaultPassword();
        this.loadForbidJoin();
        this.loadDeviceModel(this.getDeviceMode() == DeviceMode.ACCESSPOINT ? AccessPointModel.ACCESSPOINT_2010 : AccessPointModel.ACCESSPOINT_2018);
    }

    @Override
    public synchronized AccessPointType getDeviceType() {
        return AccessPointTypeMapping.getType(this.getId());
    }

    @Override
    public synchronized Password getPassword() {
        return this.password;
    }

    @Override
    public synchronized Password getDefaultPassword() {
        return this.defaultPassword;
    }

    public synchronized void setDefaultPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_DEFAULT_PASSWORD, password.getSaltedHash());
        this.defaultPassword = password;
    }

    @Override
    public synchronized void setPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_PASSWORD, password.getSaltedHash());
        this.password = password;
    }

    private void loadPassword() throws SerializeException, InitializationException {
        Password password = this.load(SYSTEM_PASSWORD, Password.class);
        if (password == null) {
            try {
                password = Password.createFromPlainPassword((String)"admin");
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
            }
        }
        this.password = password;
    }

    @Override
    public void loadDefaultPassword() throws SerializeException, InitializationException {
        Password password = this.load(SYSTEM_DEFAULT_PASSWORD, Password.class);
        if (password == null) {
            try {
                password = Password.createFromPlainPassword((String)"admin");
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
            }
        }
        this.defaultPassword = password;
    }

    @Override
    public synchronized boolean isForbidJoin() {
        return this.forbidJoin;
    }

    public synchronized void setForbidJoin(boolean forbidJoin) throws SerializeException {
        this.save(SYSTEM_FORBID_JOIN, forbidJoin);
        this.forbidJoin = forbidJoin;
    }

    private void loadForbidJoin() {
        try {
            Boolean forbidJoinObject = this.load(SYSTEM_FORBID_JOIN, Boolean.class);
            this.forbidJoin = forbidJoinObject != null ? forbidJoinObject : false;
        }
        catch (SerializeException exc) {
            this.forbidJoin = false;
        }
    }

    private void loadDeviceModel(AccessPointModel defaultDeviceModel) throws SerializeException {
        AccessPointModel model = this.load(SYSTEM_MODEL, AccessPointModel.class);
        if (model == null) {
            model = defaultDeviceModel;
        }
        this.deviceModel = model;
    }

    @Override
    public String getDeviceTypeName() {
        if (this.getDeviceMode() == DeviceMode.ACCESSPOINT_2018) {
            return this.getDeviceModel() == AccessPointModel.ACCESSPOINT_2018 ? DEVICE_NAME_AP_2020 : String.format("%s (%s)", DEVICE_NAME_AP_2020, this.getDeviceModel().toString());
        }
        return this.getDeviceType().getDeviceName();
    }

    @Override
    public String getDefaultHostname() {
        return DefaultAccessPointSystemAttributes.createDefaultHostname(this.getId());
    }

    public static String createDefaultHostname(int accessPointId) {
        if (accessPointId > 0) {
            return String.format("ap-%d", accessPointId);
        }
        return "imagotag-ap";
    }

    public synchronized void setDeviceModel(AccessPointModel accessPointModel) throws SerializeException {
        if (accessPointModel == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_MODEL, (Object)accessPointModel);
        this.deviceModel = accessPointModel;
    }

    @Override
    public AccessPointModel getDeviceModel() {
        return this.deviceModel;
    }
}

