/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PlatformConfigurationXMLSerializer
implements XMLSerializer<Object> {
    private static final ESLLogger logger = ESLLogger.getLogger(PlatformConfigurationXMLSerializer.class);
    protected final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(NetworkConfiguration networkInfo, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("network-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.appendChild(this.toXML(networkInfo, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(TimesyncConfiguration timesyncConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("timesync-form");
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(this.toXML(timesyncConfiguration, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(LoggingConfiguration loggingConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("logging-form");
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(this.toXML(loggingConfiguration, document));
        document.appendChild(root);
        return document;
    }

    protected Element toXML(NetworkConfiguration networkConfiguration, Document document) {
        Element networkElement = document.createElement("network");
        networkElement.setAttribute("hostname", networkConfiguration.getHostName());
        networkElement.setAttribute("dhcp", Boolean.toString(networkConfiguration.isDhcp()));
        if (!networkConfiguration.isDhcp()) {
            networkElement.setAttribute("address", networkConfiguration.getAddress());
            networkElement.setAttribute("netmask", networkConfiguration.getNetmask());
            networkElement.setAttribute("gateway", networkConfiguration.getGateway());
            networkElement.setAttribute("nameserver1", networkConfiguration.getNameServer1());
            networkElement.setAttribute("nameserver2", networkConfiguration.getNameServer2());
        }
        return networkElement;
    }

    protected Element toXML(LoggingConfiguration loggingConfiguration, Document document) {
        Element loggingElement = document.createElement("logging");
        loggingElement.setAttribute("socketRemoteAddress", loggingConfiguration.getSocketRemoteAddress());
        loggingElement.setAttribute("socketPort", String.valueOf(loggingConfiguration.getSocketAppenderPort()));
        loggingElement.setAttribute("socketAppenderEnabled", Boolean.toString(loggingConfiguration.isSocketAppenderEnabled()));
        loggingElement.setAttribute("logLevel", loggingConfiguration.getLogLevel().toString());
        return loggingElement;
    }

    protected Element toXML(TimesyncConfiguration timesyncConfiguration, Document document) {
        Element timesyncElement = document.createElement("timesync");
        timesyncElement.setAttribute("timeServer", timesyncConfiguration.getTimeServer());
        timesyncElement.setAttribute("enabled", Boolean.toString(timesyncConfiguration.isEnabled()));
        timesyncElement.setAttribute("updateInterval", Integer.toString(timesyncConfiguration.getUpdateInterval()));
        return timesyncElement;
    }

    protected LoggingConfiguration parseLoggingConfigurationXML(Element loggingElement) throws SerializeException {
        String logLevel = loggingElement.getAttribute("logLevel");
        try {
            String socketRemoteAddress = loggingElement.getAttribute("socketRemoteAddress");
            int socketPort = Integer.parseInt(loggingElement.getAttribute("socketPort"));
            boolean socketAppenderEnabled = Boolean.parseBoolean(loggingElement.getAttribute("socketAppenderEnabled"));
            return new LoggingConfiguration(LogLevel.valueOf(logLevel), socketPort, socketRemoteAddress, socketAppenderEnabled);
        }
        catch (Exception exc) {
            logger.info("Error parsing logging configuration. Logging set to default.");
            return new LoggingConfiguration();
        }
    }

    protected NetworkConfiguration parseNetworkInfoXML(Element networkElement) throws SerializeException {
        boolean dhcp;
        String hostName = networkElement.getAttribute("hostname");
        boolean bl = dhcp = networkElement.hasAttribute("dhcp") ? Boolean.parseBoolean(networkElement.getAttribute("dhcp")) : true;
        if (dhcp) {
            return new NetworkConfiguration(hostName);
        }
        String address = networkElement.getAttribute("address");
        String netmask = networkElement.getAttribute("netmask");
        String gateway = networkElement.getAttribute("gateway");
        String nameServer1 = networkElement.getAttribute("nameserver1");
        String nameServer2 = networkElement.getAttribute("nameserver2");
        return new NetworkConfiguration(hostName, address, netmask, gateway, nameServer1, nameServer2);
    }

    protected TimesyncConfiguration parseTimesyncConfigurationXML(Element timesyncElement) throws SerializeException {
        try {
            boolean enabled = Boolean.parseBoolean(timesyncElement.getAttribute("enabled"));
            String ntpServer = timesyncElement.getAttribute("timeServer");
            int updateInterval = Integer.parseInt(timesyncElement.getAttribute("updateInterval"));
            if (ntpServer != null) {
                return new TimesyncConfiguration(enabled, ntpServer, updateInterval);
            }
            return new TimesyncConfiguration();
        }
        catch (Exception exc) {
            logger.info("Error parsing timesync configuration. Timesync disabled.");
            return new TimesyncConfiguration();
        }
    }

    public String toString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return writer.toString();
    }

    protected Element toXML(String error, List<String> messages, Document document) {
        Element errorElement = document.createElement("error");
        errorElement.setAttribute("message", error);
        int causeCount = 0;
        for (String message : messages) {
            errorElement.setAttribute("cause" + String.valueOf(++causeCount), message);
        }
        return errorElement;
    }
}

