/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.esl.gui.validator.FormValidator;
import at.mrdevelopment.esl.gui.validator.HostValidator;
import at.mrdevelopment.esl.gui.validator.HostnameValidator;
import at.mrdevelopment.esl.gui.validator.IPAddressValidator;
import at.mrdevelopment.esl.gui.validator.LongRangeValidator;
import at.mrdevelopment.esl.gui.validator.NetmaskValidator;
import at.mrdevelopment.esl.gui.validator.PortValidator;
import at.mrdevelopment.esl.gui.validator.RangeValidator;
import com.google.common.base.Splitter;
import org.joda.time.format.DateTimeFormat;

public class ConfigurationValidator {
    private static final int MAX_INTERVAL = 525600;
    private boolean hasErrors = false;

    public boolean validate(ConfigurationForm configurationForm) {
        this.hasErrors = false;
        if (configurationForm.getFormName().equals("msp-form")) {
            this.validateMSPForm(configurationForm);
        } else if (configurationForm.getFormName().equals("network-form")) {
            this.validateNetworkForm(configurationForm);
        } else if (configurationForm.getFormName().equals("datetime-form")) {
            this.validateTimesyncForm(configurationForm);
        } else if (configurationForm.getFormName().equals("broadcast-form")) {
            this.validateBroadcastForm(configurationForm);
        } else if (configurationForm.getFormName().equals("logging-form")) {
            this.validateLoggingForm(configurationForm);
        } else if (configurationForm.getFormName().equals("serial-form")) {
            this.validateSerialForm(configurationForm);
        } else if (configurationForm.getFormName().equals("lf-form")) {
            this.validateLowFrequencyDriverForm(configurationForm);
        } else if (configurationForm.getFormName().equals("ssl-form")) {
            this.validateSSLConfigurationForm(configurationForm);
        } else if (configurationForm.getFormName().equals("multi-network-form")) {
            this.validateMultiNetworkForm(configurationForm);
        } else if (configurationForm.getFormName().equals("truststore-form")) {
            this.validateTrustStoreForm(configurationForm);
        } else if (configurationForm.getFormName().equals("comm-daemon-form")) {
            this.validateApcSettingsForm(configurationForm);
        }
        return !this.hasErrors;
    }

    private void validateTrustStoreForm(ConfigurationForm configurationForm) {
        Boolean.valueOf(configurationForm.getValue("useDefaultTrustStore"));
    }

    private void validateSSLConfigurationForm(ConfigurationForm configurationForm) {
        Boolean.valueOf(configurationForm.getValue("verifyClientCertificates"));
    }

    private void validateLowFrequencyDriverForm(ConfigurationForm configurationForm) {
        Boolean.valueOf(configurationForm.getValue("enabled"));
    }

    private void validateSerialForm(ConfigurationForm serialForm) {
        boolean wiSpyEnabled = Boolean.valueOf(serialForm.getValue("wiSpyEnabled"));
        if (wiSpyEnabled) {
            String startFrequency = serialForm.getValue("startFrequency");
            String endFrequency = serialForm.getValue("endFrequency");
            String numberOfSweeps = serialForm.getValue("numberOfSweeps");
            String filterBandwidth = serialForm.getValue("channelFilterBandwidth");
            LongRangeValidator frequencyValidator = new LongRangeValidator(1664000000L, 3328000000L, false);
            frequencyValidator.setValue(startFrequency);
            frequencyValidator.validate();
            this.addErrors("startFrequency", serialForm, frequencyValidator);
            frequencyValidator.setValue(endFrequency);
            frequencyValidator.validate();
            this.addErrors("endFrequency", serialForm, frequencyValidator);
            if (!this.hasErrors) {
                long end;
                long start = Long.parseLong(startFrequency);
                if (start > (end = Long.parseLong(endFrequency))) {
                    serialForm.addMessage("endFrequency", "End frequency must be greater than start frequency");
                    this.hasErrors = true;
                } else if (end - start < 397L) {
                    serialForm.addMessage("endFrequency", "The difference between start and end frequency must be at least 397 Hz");
                    this.hasErrors = true;
                }
            }
            RangeValidator numberOfSweepsValidator = new RangeValidator(1, 255, false);
            numberOfSweepsValidator.setValue(numberOfSweeps);
            numberOfSweepsValidator.validate();
            this.addErrors("numberOfSweeps", serialForm, numberOfSweepsValidator);
            if (filterBandwidth == null || filterBandwidth.isEmpty()) {
                this.hasErrors = true;
                serialForm.addMessage("channelFilterBandwidth", "No Channel Filter Bandwidth selected");
            }
        }
    }

    private void validateMultiNetworkForm(ConfigurationForm networkForm) {
        String hostname = networkForm.getValue("hostname");
        String nameserver1 = networkForm.getValue("nameserver1");
        String nameserver2 = networkForm.getValue("nameserver2");
        String gateway = networkForm.getValue("gateway");
        boolean bridgeEnabled = Boolean.valueOf(networkForm.getValue("bridgedEnabled"));
        boolean bridgeDhcp = Boolean.valueOf(networkForm.getValue("bridgedDhcp"));
        String bridgeAddress = networkForm.getValue("bridgedAddress");
        String bridgeNetmask = networkForm.getValue("bridgedNetmask");
        this.validateHostname(hostname, networkForm, "hostname", false);
        if (bridgeEnabled) {
            if (bridgeDhcp) {
                if (!bridgeAddress.isEmpty()) {
                    networkForm.addMessage("bridgedAddress", "Must be empty if DHCP is selected");
                    this.hasErrors = true;
                }
                if (!bridgeNetmask.isEmpty()) {
                    networkForm.addMessage("bridgedNetmask", "Must be empty if DHCP is selected");
                    this.hasErrors = true;
                }
                if (!nameserver1.isEmpty()) {
                    networkForm.addMessage("nameserver1", "Must be empty if DHCP for bridge is selected");
                    this.hasErrors = true;
                }
                if (!nameserver2.isEmpty()) {
                    networkForm.addMessage("nameserver2", "Must be empty if DHCP for bridge is selected");
                    this.hasErrors = true;
                }
            } else {
                this.validateIPAddress(bridgeAddress, networkForm, "bridgedAddress", bridgeDhcp);
                this.validateNetmask(bridgeNetmask, networkForm, "bridgedNetmask", bridgeDhcp);
            }
        } else {
            Iterable adapterNames = Splitter.on((String)",").split((CharSequence)networkForm.getValue("adapternames"));
            for (String adapterName : adapterNames) {
                boolean dhcp = Boolean.valueOf(networkForm.getValue(String.format("%s_dhcp", adapterName)));
                String address = networkForm.getValue(String.format("%s_address", adapterName));
                String netmask = networkForm.getValue(String.format("%s_netmask", adapterName));
                if (dhcp) {
                    if (!address.isEmpty()) {
                        networkForm.addMessage(String.format("%s_address", adapterName), "Must be empty if DHCP is selected");
                        this.hasErrors = true;
                    }
                    if (!netmask.isEmpty()) {
                        networkForm.addMessage(String.format("%s_netmask", adapterName), "Must be empty if DHCP is selected");
                        this.hasErrors = true;
                    }
                }
                this.validateIPAddress(address, networkForm, String.format("%s_address", adapterName), dhcp);
                this.validateNetmask(netmask, networkForm, String.format("%s_netmask", adapterName), dhcp);
            }
        }
        this.validateIPAddress(gateway, networkForm, "gateway", true);
        this.validateIPAddress(nameserver1, networkForm, "nameserver1", true);
        this.validateIPAddress(nameserver2, networkForm, "nameserver2", true);
    }

    private void validateNetworkForm(ConfigurationForm networkForm) {
        boolean dhcp = Boolean.valueOf(networkForm.getValue("dhcp"));
        String hostname = networkForm.getValue("hostname");
        String address = networkForm.getValue("address");
        String netmask = networkForm.getValue("netmask");
        String gateway = networkForm.getValue("gateway");
        String nameserver1 = networkForm.getValue("nameserver1");
        String nameserver2 = networkForm.getValue("nameserver2");
        this.validateHostname(hostname, networkForm, "hostname", false);
        if (dhcp) {
            if (!address.isEmpty()) {
                networkForm.addMessage("address", "Must be empty if DHCP is selected");
                this.hasErrors = true;
            }
            if (!netmask.isEmpty()) {
                networkForm.addMessage("netmask", "Must be empty if DHCP is selected");
                this.hasErrors = true;
            }
            if (!gateway.isEmpty()) {
                networkForm.addMessage("gateway", "Must be empty if DHCP is selected");
                this.hasErrors = true;
            }
            if (!nameserver1.isEmpty()) {
                networkForm.addMessage("nameserver1", "Must be empty if DHCP is selected");
                this.hasErrors = true;
            }
            if (!nameserver2.isEmpty()) {
                networkForm.addMessage("nameserver2", "Must be empty if DHCP is selected");
                this.hasErrors = true;
            }
        }
        this.validateIPAddress(address, networkForm, "address", dhcp);
        this.validateNetmask(netmask, networkForm, "netmask", dhcp);
        this.validateIPAddress(gateway, networkForm, "gateway", true);
        this.validateIPAddress(nameserver1, networkForm, "nameserver1", true);
        this.validateIPAddress(nameserver2, networkForm, "nameserver2", true);
    }

    private void validateTimesyncForm(ConfigurationForm timesyncForm) {
        boolean enabled = Boolean.valueOf(timesyncForm.getValue("enabled"));
        String timeServer = timesyncForm.getValue("timeServer");
        String updateInterval = timesyncForm.getValue("updateInterval");
        if (enabled) {
            if (timeServer.isEmpty()) {
                timesyncForm.addMessage("timeServer", "Must be set if enabled");
                this.hasErrors = true;
            }
            if (updateInterval.isEmpty()) {
                timesyncForm.addMessage("updateInterval", "Must be set if enabled");
                this.hasErrors = true;
            }
        } else {
            String day = timesyncForm.getValue("day");
            String month = timesyncForm.getValue("month");
            String year = timesyncForm.getValue("year");
            String hours = timesyncForm.getValue("hours");
            String minutes = timesyncForm.getValue("minutes");
            try {
                DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm").parseDateTime(String.format("%s.%s.%s %s:%s", day, month, year, hours, minutes));
            }
            catch (IllegalArgumentException exc) {
                timesyncForm.addMessage("day", "Invalid time/date.");
                this.hasErrors = true;
            }
        }
        this.validateHost(timeServer, timesyncForm, "timeServer", !enabled);
        this.validateInterval(updateInterval, timesyncForm, "updateInterval", !enabled);
    }

    private void validateMSPForm(ConfigurationForm mspForm) {
        boolean enabled = Boolean.valueOf(mspForm.getValue("enabled"));
        String relayHost = mspForm.getValue("relayHostname");
        String port = mspForm.getValue("port");
        String uploadInterval = mspForm.getValue("uploadInterval");
        if (enabled) {
            if (relayHost.isEmpty()) {
                mspForm.addMessage("relayHostname", "Must be set if enabled");
                this.hasErrors = true;
            }
            if (port.isEmpty()) {
                mspForm.addMessage("port", "Must be set if enabled");
                this.hasErrors = true;
            }
            if (uploadInterval.isEmpty()) {
                mspForm.addMessage("uploadInterval", "Must be set if enabled");
                this.hasErrors = true;
            }
        }
        this.validateHost(relayHost, mspForm, "relayHostname", !enabled);
        this.validatePort(port, mspForm, "port", !enabled);
        this.validateInterval(uploadInterval, mspForm, "uploadInterval", !enabled);
    }

    private void validateBroadcastForm(ConfigurationForm broadcastForm) {
        boolean enabled = Boolean.valueOf(broadcastForm.getValue("enabled"));
        String port = broadcastForm.getValue("broadcastPort");
        String interval = broadcastForm.getValue("broadcastIntervalInMinutes");
        if (enabled) {
            if (port.isEmpty()) {
                broadcastForm.addMessage("broadcastPort", "Must be set if enabled");
                this.hasErrors = true;
            }
            if (interval.isEmpty()) {
                broadcastForm.addMessage("broadcastIntervalInMinutes", "Must be set if enabled");
                this.hasErrors = true;
            }
        }
        this.validatePort(port, broadcastForm, "broadcastPort", !enabled);
        this.validateInterval(interval, broadcastForm, "broadcastIntervalInMinutes", !enabled);
    }

    private void validateLoggingForm(ConfigurationForm loggingForm) {
        String logLevel = loggingForm.getValue("logLevel");
        boolean enabled = Boolean.valueOf(loggingForm.getValue("socketAppenderEnabled"));
        String loggingHost = loggingForm.getValue("socketRemoteAddress");
        String loggingPort = loggingForm.getValue("socketPort");
        if (logLevel.isEmpty()) {
            loggingForm.addMessage("logLevel", "Must be set");
            this.hasErrors = true;
        }
        if (enabled) {
            if (loggingHost.isEmpty()) {
                loggingForm.addMessage("socketRemoteAddress", "Must be set if enabled");
                this.hasErrors = true;
            }
            if (loggingPort.isEmpty()) {
                loggingForm.addMessage("socketPort", "Must be set if enabled");
                this.hasErrors = true;
            }
        }
        this.validateHost(loggingHost, loggingForm, "socketRemoteAddress", !enabled);
        this.validatePort(loggingPort, loggingForm, "socketPort", !enabled);
    }

    private void validateHostname(String hostname, ConfigurationForm form, String field, boolean allowEmpty) {
        HostnameValidator validator = new HostnameValidator(allowEmpty);
        validator.setValue(hostname);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void validateIPAddress(String ipAddress, ConfigurationForm form, String field, boolean allowEmpty) {
        IPAddressValidator validator = new IPAddressValidator(allowEmpty);
        validator.setValue(ipAddress);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void validateNetmask(String netmask, ConfigurationForm form, String field, boolean allowEmpty) {
        NetmaskValidator validator = new NetmaskValidator(allowEmpty);
        validator.setValue(netmask);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void validateHost(String host, ConfigurationForm form, String field, boolean allowEmpty) {
        HostValidator validator = new HostValidator(allowEmpty);
        validator.setValue(host);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void validatePort(String port, ConfigurationForm form, String field, boolean allowEmpty) {
        PortValidator validator = new PortValidator(allowEmpty);
        validator.setValue(port);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void validateInterval(String interval, ConfigurationForm form, String field, boolean allowEmpty) {
        RangeValidator validator = new RangeValidator(1, 525600, allowEmpty);
        validator.setValue(interval);
        validator.validate();
        this.addErrors(field, form, validator);
    }

    private void addErrors(String fieldName, ConfigurationForm configurationForm, FormValidator<?> validator) {
        for (String error : validator.getErrors()) {
            configurationForm.addMessage(fieldName, error);
            this.hasErrors = true;
        }
    }

    private void validateApcSettingsForm(ConfigurationForm apcSettingsForm) {
        String thinMode = apcSettingsForm.getValue("thinMode");
        String outboundMode = apcSettingsForm.getValue("outboundMode");
        if (Boolean.valueOf(thinMode).booleanValue() && Boolean.valueOf(outboundMode).booleanValue()) {
            String apcAddress = apcSettingsForm.getValue("apc-address");
            this.validateHost(apcAddress, apcSettingsForm, "apc-address", false);
            String apcPort = apcSettingsForm.getValue("apc-port");
            this.validatePort(apcPort, apcSettingsForm, "apc-port", false);
        }
    }
}

