/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Splitter;
import java.util.Map;
import org.apache.http.HttpEntity;

public class ConfigurationHtmlFormParser {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationHtmlFormParser.class);

    public ConfigurationForm parseTransmissionConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm transmissionForm = new ConfigurationForm("wireless-form");
            transmissionForm.setValue("wirelessChannel", formParser.getValue("wirelessChannel"));
            transmissionForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return transmissionForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseNetworkInfoConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm networkForm = new ConfigurationForm("network-form");
            networkForm.setValue("hostname", formParser.getValue("hostname"));
            networkForm.setValue("dhcp", String.valueOf(formParser.getBooleanValue("dhcp")));
            networkForm.setValue("address", formParser.getValue("address"));
            networkForm.setValue("gateway", formParser.getValue("gateway"));
            networkForm.setValue("nameserver1", formParser.getValue("nameserver1"));
            networkForm.setValue("nameserver2", formParser.getValue("nameserver2"));
            networkForm.setValue("netmask", formParser.getValue("netmask"));
            networkForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return networkForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseMultiNetworkInfoConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm networkForm = new ConfigurationForm("multi-network-form");
            String networkMode = formParser.getValue("networkMode");
            boolean bridgeEnabled = networkMode == null || networkMode.equals("Bridged");
            boolean bridgeDhcp = formParser.getBooleanValue("dhcp");
            networkForm.addValue("bridgedEnabled", String.valueOf(bridgeEnabled));
            networkForm.addValue("bridgedDhcp", String.valueOf(bridgeDhcp));
            String bridgeAddress = formParser.getValue("address");
            String bridgeNetmask = formParser.getValue("netmask");
            networkForm.addValue("bridgedAddress", bridgeAddress != null ? bridgeAddress : "");
            networkForm.addValue("bridgedNetmask", bridgeNetmask != null ? bridgeNetmask : "");
            networkForm.addValue("hostname", formParser.getValue("hostname"));
            networkForm.addValue("adapternames", formParser.getValue("adapternames"));
            Iterable adapters = Splitter.on((String)",").split((CharSequence)formParser.getValue("adapternames"));
            int index = 0;
            for (String string : adapters) {
                boolean dhcp = formParser.getBooleanValue(String.format("%s_dhcp", string));
                networkForm.addValue(String.format("%s_dhcp", string), String.valueOf(dhcp));
                String address = formParser.getValue(String.format("%s_address", string));
                String netmask = formParser.getValue(String.format("%s_netmask", string));
                networkForm.addValue(String.format("%s_address", string), address != null ? address : "");
                networkForm.addValue(String.format("%s_netmask", string), netmask != null ? netmask : "");
                networkForm.addValue(String.format("%s_index", string), String.valueOf(index));
                ++index;
            }
            for (Map.Entry entry : formParser.getContent().entrySet()) {
                networkForm.addValue((String)entry.getKey(), (String)entry.getValue());
            }
            String nameServer1 = formParser.getValue("nameserver1");
            String string = formParser.getValue("nameserver2");
            String gateway = formParser.getValue("gateway");
            networkForm.addValue("nameserver1", nameServer1 != null ? nameServer1 : "");
            networkForm.addValue("nameserver2", string != null ? string : "");
            networkForm.addValue("gateway", gateway != null ? gateway : "");
            return networkForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseDateTimeForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm dateTimeForm = new ConfigurationForm("datetime-form");
            dateTimeForm.setValue("enabled", String.valueOf(formParser.getBooleanValue("enabled")));
            dateTimeForm.setValue("timeServer", formParser.getValue("timeServer"));
            dateTimeForm.setValue("updateInterval", formParser.getValue("updateInterval"));
            dateTimeForm.setValue("autoConfig", Boolean.toString(autoConfig));
            dateTimeForm.setValue("timeZone", formParser.getValue("timeZone"));
            dateTimeForm.setValue("day", formParser.getValue("day"));
            dateTimeForm.setValue("month", formParser.getValue("month"));
            dateTimeForm.setValue("year", formParser.getValue("year"));
            dateTimeForm.setValue("hours", formParser.getValue("hours"));
            dateTimeForm.setValue("minutes", formParser.getValue("minutes"));
            dateTimeForm.setValue("fixedDateTime", formParser.getValue("fixedDateTime"));
            return dateTimeForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseMSPConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm mspForm = new ConfigurationForm("msp-form");
            mspForm.setValue("enabled", String.valueOf(formParser.getBooleanValue("enabled")));
            mspForm.setValue("relayHostname", formParser.getValue("relayHostname"));
            mspForm.setValue("port", formParser.getValue("port"));
            mspForm.setValue("username", formParser.getValue("username"));
            mspForm.setValue("password", formParser.getValue("password"));
            mspForm.setValue("path", formParser.getValue("path"));
            mspForm.setValue("uploadInterval", formParser.getValue("uploadInterval"));
            mspForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return mspForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseBroadcastConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm broadcastForm = new ConfigurationForm("broadcast-form");
            broadcastForm.setValue("enabled", String.valueOf(formParser.getBooleanValue("enabled")));
            broadcastForm.setValue("broadcastIntervalInMinutes", formParser.getValue("broadcastIntervalInMinutes"));
            broadcastForm.setValue("broadcastPort", formParser.getValue("broadcastPort"));
            broadcastForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return broadcastForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseLoggingConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm loggingForm = new ConfigurationForm("logging-form");
            loggingForm.setValue("socketAppenderEnabled", String.valueOf(formParser.getBooleanValue("socketAppenderEnabled")));
            loggingForm.setValue("socketPort", formParser.getValue("socketPort"));
            loggingForm.setValue("socketRemoteAddress", formParser.getValue("socketRemoteAddress"));
            loggingForm.setValue("logLevel", formParser.getValue("logLevel"));
            loggingForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return loggingForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseOutputPowerConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm rfForm = new ConfigurationForm("rf-power-form");
            rfForm.setValue("rfPower", formParser.getValue("rfPower"));
            rfForm.setValue("autoConfig", Boolean.toString(autoConfig));
            return rfForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseLowFrequencyDriverConfigurationForm(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm lfForm = new ConfigurationForm("lf-form");
            lfForm.setValue("enabled", String.valueOf(formParser.getBooleanValue("lfEnabled")));
            return lfForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseSSLConfigurationForm(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm sslForm = new ConfigurationForm("ssl-form");
            sslForm.setValue("verifyClientCertificates", String.valueOf(formParser.getBooleanValue("verifyClientCertificates")));
            return sslForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseApplianceWebserviceConfiguration(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm wsForm = this.parseWebservice(formParser);
            wsForm.addValue("jerseyPortSSL", this.getWebserviceStateFromSelect(formParser.getValue("serviceJersey")));
            if (formParser.getValue("interfaces") != null) {
                String interfacesString = formParser.getValue("interfaces");
                wsForm.addValue("interfaces", interfacesString);
                for (String interfaceName : Splitter.on((String)";").split((CharSequence)interfacesString)) {
                    String interfaceEnabled = formParser.getValue(String.format("%s_interface", interfaceName));
                    wsForm.addValue(String.format("%s_interface", interfaceName), interfaceEnabled.equals("Disabled") ? "false" : "true");
                }
            }
            return wsForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private ConfigurationForm parseWebservice(HttpFormParser formParser) throws SerializeException {
        try {
            ConfigurationForm wsForm = new ConfigurationForm("ws-form");
            wsForm.setValue("httpPortEnabled", String.valueOf(this.getBooleanFromWebserviceSelect(formParser.getValue("portHttp"))));
            wsForm.setValue("httpsPortEnabled", String.valueOf(this.getBooleanFromWebserviceSelect(formParser.getValue("portHttps"))));
            wsForm.setValue("defaultServicePortSSL", this.getWebserviceStateFromSelect(formParser.getValue("serviceDefault")));
            return wsForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseWebserviceConfiguration(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            return this.parseWebservice(formParser);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private String getWebserviceStateFromSelect(String value) {
        if (value != null) {
            if (value.toLowerCase().equals("http")) {
                return WebserviceConfiguration.WebserviceState.ENABLED_NORMAL.name();
            }
            if (value.toLowerCase().equals("https")) {
                return WebserviceConfiguration.WebserviceState.ENABLED_SSL.name();
            }
            if (value.toLowerCase().equals("deactivated")) {
                return WebserviceConfiguration.WebserviceState.DISABLED.name();
            }
        }
        return null;
    }

    private boolean getBooleanFromWebserviceSelect(String value) {
        return value != null && (value.equals("activated") || value.equals("HTTPS"));
    }

    public ConfigurationForm parseTrustStoreConfiguration(HttpEntity body, boolean autoConfig) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm trustStoreForm = new ConfigurationForm("truststore-form");
            trustStoreForm.addValue("autoConfig", Boolean.toString(autoConfig));
            trustStoreForm.addValue("useDefaultTrustStore", Boolean.toString(formParser.getBooleanValue("useDefaultTrustStore")));
            return trustStoreForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseServiceLevelConfiguration(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm serviceLevelForm = new ConfigurationForm("service-level-form");
            String level = formParser.getValue("serviceLevel");
            int serviceLevel = 3;
            if (level.equals("Level 1")) {
                serviceLevel = 1;
            } else if (level.equals("Level 2")) {
                serviceLevel = 2;
            }
            serviceLevelForm.setValue("serviceLevel", String.valueOf(serviceLevel));
            return serviceLevelForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm parseCommunicationDaemonConfigurationForm(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm communicationDaemonSettingsForm = new ConfigurationForm("comm-daemon-form");
            communicationDaemonSettingsForm.setValue("thinMode", String.valueOf(formParser.getBooleanValue("thinMode")));
            communicationDaemonSettingsForm.setValue("outboundMode", String.valueOf(formParser.getBooleanValue("outboundMode")));
            communicationDaemonSettingsForm.setValue("apc-address", formParser.getValue("apc-address"));
            communicationDaemonSettingsForm.setValue("apc-port", formParser.getValue("apc-port"));
            communicationDaemonSettingsForm.setValue("tlsEnabled", String.valueOf(formParser.getBooleanValue("tlsEnabled")));
            communicationDaemonSettingsForm.setValue("tlsStrictVerificationEnabled", String.valueOf(formParser.getBooleanValue("tlsStrictVerificationEnabled")));
            return communicationDaemonSettingsForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }
}

