/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LowFrequencyDriverConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.BridgeNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfigurationEntry;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.esl.certificate.ESLTrustStore;
import at.mrdevelopment.esl.core.ESLSystemDefaults;
import at.mrdevelopment.esl.core.OutputPower;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.xml.KeyStoreXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationForm {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationForm.class);
    public static final String WIRELESS_FORM = "wireless-form";
    public static final String NETWORK_FORM = "network-form";
    public static final String MULTI_NETWORK_FORM = "multi-network-form";
    public static final String DATETIME_FORM = "datetime-form";
    public static final String MSP_FORM = "msp-form";
    public static final String AUTOCONFIG_FORM = "autoConfig-form";
    public static final String BROADCAST_FORM = "broadcast-form";
    public static final String RF_POWER_FORM = "rf-power-form";
    public static final String LOGGING_FORM = "logging-form";
    public static final String SERIAL_FORM = "serial-form";
    public static final String LF_FORM = "lf-form";
    public static final String SSL_CONFIGURATION_FORM = "ssl-form";
    public static final String WS_CONFIGURATION_FORM = "ws-form";
    public static final String TRUSTSTORE_CONFIGURATION_FORM = "truststore-form";
    public static final String SERVICE_LEVEL_CONFIGURATION_FORM = "service-level-form";
    public static final String VPN_FORM = "vpn-form";
    public static final String COMM_DAEMON_FORM = "comm-daemon-form";
    private final XMLToolkit xmlToolkit;
    private final String formName;
    private Map<String, String> values;
    private Map<String, List<String>> messages;

    public ConfigurationForm(String formName) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        if (formName.equals(WIRELESS_FORM)) {
            this.initWirelessForm();
        } else if (formName.equals(NETWORK_FORM)) {
            this.initNetworkForm();
        } else if (formName.equals(MULTI_NETWORK_FORM)) {
            this.values = new HashMap<String, String>();
            this.messages = new HashMap<String, List<String>>();
        } else if (formName.equals(DATETIME_FORM)) {
            this.initTimesyncForm();
        } else if (formName.equals(MSP_FORM)) {
            this.initMSPForm();
        } else if (formName.equals(AUTOCONFIG_FORM)) {
            this.initAutoConfigForm();
        } else if (formName.equals(BROADCAST_FORM)) {
            this.initBroadcastForm();
        } else if (formName.equals(LOGGING_FORM)) {
            this.initLoggingForm();
        } else if (formName.equals(SERIAL_FORM)) {
            this.initSerialForm();
        } else if (formName.equals(RF_POWER_FORM)) {
            this.initRfPowerForm();
        } else if (formName.equals(LF_FORM)) {
            this.initLFForm();
        } else if (formName.equals(SSL_CONFIGURATION_FORM)) {
            this.initSSLConfigurationForm();
        } else if (formName.equals(WS_CONFIGURATION_FORM)) {
            this.initWebserviceConfigurationForm();
        } else if (formName.equals(TRUSTSTORE_CONFIGURATION_FORM)) {
            this.initTrustStoreConfigurationForm();
        } else if (formName.equals(SERVICE_LEVEL_CONFIGURATION_FORM)) {
            this.initServiceLevelConfigurationForm();
        } else if (formName.equals(COMM_DAEMON_FORM)) {
            this.initAPCSettingsForm();
        } else {
            throw new InitializationException("Form type not supported", new Object[0]);
        }
        this.formName = formName;
    }

    public ConfigurationForm(ServiceLevelConfiguration serviceLevelConfiguration) throws InitializationException {
        this.formName = SERVICE_LEVEL_CONFIGURATION_FORM;
        this.xmlToolkit = new XMLToolkit();
        this.initServiceLevelConfigurationForm();
        this.values.put("serviceLevel", String.valueOf(serviceLevelConfiguration.getLevel()));
    }

    public ConfigurationForm(MultiNetworkInterfaceConfiguration networkConfiguration) throws InitializationException {
        this.formName = MULTI_NETWORK_FORM;
        this.xmlToolkit = new XMLToolkit();
        this.initMultiNetworkForm(networkConfiguration);
    }

    public ConfigurationForm(TrustStoreConfiguration trustStoreConfiguration) throws InitializationException {
        this.formName = TRUSTSTORE_CONFIGURATION_FORM;
        this.xmlToolkit = new XMLToolkit();
        this.initTrustStoreConfigurationForm();
        this.values.put("useDefaultTrustStore", String.valueOf(trustStoreConfiguration.isUseDefaultTrustStore()));
    }

    public ConfigurationForm(LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = LF_FORM;
        this.initLFForm();
        this.values.put("enabled", String.valueOf(lowFrequencyDriverConfiguration.isEnabled()));
    }

    public ConfigurationForm(MSPConfiguration mspConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = MSP_FORM;
        this.initMSPForm();
        this.values.put("relayHostname", mspConfiguration.getHost());
        this.values.put("port", String.valueOf(mspConfiguration.getPort()));
        this.values.put("username", mspConfiguration.getUsername());
        this.values.put("password", mspConfiguration.getPassword());
        this.values.put("path", mspConfiguration.getPath());
        this.values.put("enabled", String.valueOf(mspConfiguration.isEnabled()));
        this.values.put("uploadInterval", String.valueOf(mspConfiguration.getUploadInterval()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(NetworkConfiguration networkInfo, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = NETWORK_FORM;
        this.initNetworkForm();
        this.values.put("hostname", networkInfo.getHostName());
        this.values.put("dhcp", String.valueOf(networkInfo.isDhcp()));
        this.values.put("address", networkInfo.getAddress());
        this.values.put("gateway", networkInfo.getGateway());
        this.values.put("nameserver1", networkInfo.getNameServer1());
        this.values.put("nameserver2", networkInfo.getNameServer2());
        this.values.put("netmask", networkInfo.getNetmask());
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(TimesyncConfiguration timesyncConfiguration, TimeZoneConfiguration timeZoneConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = DATETIME_FORM;
        this.initTimesyncForm();
        this.values.put("updateInterval", String.valueOf(timesyncConfiguration.getUpdateInterval()));
        this.values.put("timeServer", timesyncConfiguration.getTimeServer());
        this.values.put("enabled", String.valueOf(timesyncConfiguration.isEnabled()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
        this.values.put("timeZone", timeZoneConfiguration.getTimeZoneString());
    }

    public ConfigurationForm(WirelessConfiguration transmissionConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = WIRELESS_FORM;
        this.initWirelessForm();
        this.values.put("autoConfig", String.valueOf(autoConfig));
        this.values.put("wirelessChannel", transmissionConfiguration.getChannel() != null ? Integer.toString(transmissionConfiguration.getChannel().getChannelId()) : "");
    }

    public ConfigurationForm(DeviceMode deviceMode, boolean autoConfigEnabled) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = AUTOCONFIG_FORM;
        this.initAutoConfigForm();
        this.values.put("deviceMode", deviceMode.name());
        this.values.put("autoConfig", String.valueOf(autoConfigEnabled));
    }

    public ConfigurationForm(BroadcastConfiguration broadcastConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = BROADCAST_FORM;
        this.initBroadcastForm();
        this.values.put("enabled", String.valueOf(broadcastConfiguration.isBroadcastEnabled()));
        this.values.put("broadcastPort", String.valueOf(broadcastConfiguration.getBroadcastPort()));
        this.values.put("broadcastIntervalInMinutes", String.valueOf(broadcastConfiguration.getTimeIntervalInMinutes()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(LoggingConfiguration loggingConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = LOGGING_FORM;
        this.initLoggingForm();
        this.values.put("socketAppenderEnabled", String.valueOf(loggingConfiguration.isSocketAppenderEnabled()));
        this.values.put("socketPort", String.valueOf(loggingConfiguration.getSocketAppenderPort()));
        this.values.put("logLevel", loggingConfiguration.getLogLevel().toString());
        this.values.put("socketRemoteAddress", loggingConfiguration.getSocketRemoteAddress());
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(OutputPower radioOutputPowerLevel, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = RF_POWER_FORM;
        this.initRfPowerForm();
        this.values.put("rfPower", String.valueOf(radioOutputPowerLevel.name()));
        this.values.put("autoConfig", String.valueOf(autoConfig));
    }

    public ConfigurationForm(SSLConfiguration sslConfiguration, boolean autoConfig) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = SSL_CONFIGURATION_FORM;
        this.initSSLConfigurationForm();
        this.values.put("verifyClientCertificates", String.valueOf(sslConfiguration.isVerifyClientCertificates()));
    }

    public ConfigurationForm(DeviceMode deviceMode, ApplianceWebserviceConfiguration webserviceConfiguration, int defaultPort, int webservicePort, Collection<String> availableNetworkInterfaces) throws InitializationException {
        this(deviceMode, webserviceConfiguration, defaultPort);
        this.initApplianceWebserviceConfigurationForm(webserviceConfiguration, availableNetworkInterfaces);
        this.addDefaultAppliancePort(defaultPort, webservicePort);
        this.values.put("jerseyPortSSL", webserviceConfiguration.getWebservicePortState().name());
    }

    public ConfigurationForm(DeviceMode deviceMode, WebserviceConfiguration webserviceConfiguration, int defaultPort) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = WS_CONFIGURATION_FORM;
        this.initWebserviceConfigurationForm();
        this.addDefaultWebservicePort(defaultPort);
        this.values.put("deviceMode", deviceMode.name());
        this.values.put("httpPortEnabled", String.valueOf(webserviceConfiguration.isHttpPortEnabled()));
        this.values.put("httpsPortEnabled", String.valueOf(webserviceConfiguration.isHttpsPortEnabled()));
        this.values.put("defaultServicePortSSL", webserviceConfiguration.getDefaultServiceState().name());
    }

    public ConfigurationForm(ClientVPNConfiguration vpnConfiguration) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = VPN_FORM;
        this.initVPNForm(vpnConfiguration);
    }

    public ConfigurationForm(DeviceMode deviceMode, ThinAPConfiguration thinAPConfiguration) throws InitializationException {
        this.xmlToolkit = new XMLToolkit();
        this.formName = COMM_DAEMON_FORM;
        this.initAPCSettingsForm();
        this.values.put("deviceMode", deviceMode.name());
        this.values.put("thinMode", String.valueOf(thinAPConfiguration.isModeEnabled()));
        this.values.put("outboundMode", String.valueOf(thinAPConfiguration.isOutboundModeEnabled()));
        this.values.put("apc-address", thinAPConfiguration.getApcAddress());
        this.values.put("apc-port", String.valueOf(thinAPConfiguration.getApcPort()));
        this.values.put("tlsEnabled", String.valueOf(thinAPConfiguration.isTLSEnabled()));
        this.values.put("tlsStrictVerificationEnabled", String.valueOf(thinAPConfiguration.isTLSStrictVerficationEnabled()));
    }

    private void initServiceLevelConfigurationForm() {
        this.values = new HashMap<String, String>();
        this.values.put("serviceLevel", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("serviceLevel", new ArrayList());
    }

    private void initTrustStoreConfigurationForm() {
        this.values = new HashMap<String, String>();
        this.values.put("useDefaultTrustStore", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("useDefaultTrustStore", new ArrayList());
    }

    private void initApplianceWebserviceConfigurationForm(ApplianceWebserviceConfiguration webserviceConfiguration, Collection<String> availableNetworkInterfaces) {
        this.values.put("jerseyPortSSL", "");
        this.messages.put("jerseyPortSSL", new ArrayList());
        if (availableNetworkInterfaces.size() > 1) {
            this.values.put("interfaces", Joiner.on((String)";").join(availableNetworkInterfaces));
            this.messages.put("interfaces", new ArrayList());
            for (String networkInterfaceName : availableNetworkInterfaces) {
                this.values.put(networkInterfaceName + "_interface", webserviceConfiguration.hasDisabledInterfaces() ? String.valueOf(!webserviceConfiguration.getDisabledInterfaces().contains(networkInterfaceName)) : "true");
                this.messages.put(networkInterfaceName + "_interface", new ArrayList());
            }
        }
    }

    private void initWebserviceConfigurationForm() {
        this.values = new HashMap<String, String>();
        this.values.put("httpPortEnabled", "");
        this.values.put("httpsPortEnabled", "");
        this.values.put("defaultServicePortSSL", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("httpPortEnabled", new ArrayList());
        this.messages.put("httpsPortEnabled", new ArrayList());
        this.messages.put("defaultServicePortSSL", new ArrayList());
    }

    private void initSSLConfigurationForm() {
        this.values = new HashMap<String, String>();
        this.values.put("verifyClientCertificates", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("verifyClientCertificates", new ArrayList());
    }

    private void initSerialForm() {
        this.values = new HashMap<String, String>();
        this.values.put("wiSpyEnabled", "");
        this.values.put("startFrequency", "");
        this.values.put("endFrequency", "");
        this.values.put("numberOfSweeps", "");
        this.values.put("channelFilterBandwidth", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("wiSpyEnabled", new ArrayList());
        this.messages.put("startFrequency", new ArrayList());
        this.messages.put("endFrequency", new ArrayList());
        this.messages.put("numberOfSweeps", new ArrayList());
        this.messages.put("channelFilterBandwidth", new ArrayList());
    }

    private void initLoggingForm() {
        this.values = new HashMap<String, String>();
        this.values.put("socketAppenderEnabled", "");
        this.values.put("socketPort", "");
        this.values.put("logLevel", "");
        this.values.put("socketRemoteAddress", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("socketAppenderEnabled", new ArrayList());
        this.messages.put("socketPort", new ArrayList());
        this.messages.put("logLevel", new ArrayList());
        this.messages.put("socketRemoteAddress", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initNetworkForm() {
        this.values = new HashMap<String, String>();
        this.values.put("hostname", "");
        this.values.put("dhcp", "");
        this.values.put("address", "");
        this.values.put("gateway", "");
        this.values.put("nameserver1", "");
        this.values.put("nameserver2", "");
        this.values.put("netmask", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("hostname", new ArrayList());
        this.messages.put("dhcp", new ArrayList());
        this.messages.put("address", new ArrayList());
        this.messages.put("gateway", new ArrayList());
        this.messages.put("nameserver1", new ArrayList());
        this.messages.put("nameserver2", new ArrayList());
        this.messages.put("netmask", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initMultiNetworkForm(MultiNetworkInterfaceConfiguration networkConfiguration) {
        this.values = new HashMap<String, String>();
        this.messages = new HashMap<String, List<String>>();
        this.values.put("hostname", networkConfiguration.getHostName());
        this.values.put("nameserver1", networkConfiguration.getNameServer1());
        this.values.put("nameserver2", networkConfiguration.getNameServer2());
        this.values.put("gateway", networkConfiguration.getGateway());
        this.values.put("bridgedEnabled", String.valueOf(networkConfiguration.getBridgeConfiguration().isEnabled()));
        this.values.put("bridgedDhcp", String.valueOf(networkConfiguration.getBridgeConfiguration().isDhcp()));
        this.values.put("bridgedAddress", networkConfiguration.getBridgeConfiguration().getAddress());
        this.values.put("bridgedNetmask", networkConfiguration.getBridgeConfiguration().getNetmask());
        int index = 0;
        for (NetworkInterfaceConfigurationEntry entry : networkConfiguration.getInterfaces()) {
            if (this.values.containsKey("adapternames")) {
                this.values.put("adapternames", this.values.get("adapternames") + "," + entry.getInterfaceName());
            } else {
                this.values.put("adapternames", entry.getInterfaceName());
                this.messages.put("adapternames", new ArrayList());
            }
            this.values.put(entry.getInterfaceName() + "_dhcp", String.valueOf(entry.getNetworkInterface().isDhcp()));
            this.messages.put(entry.getInterfaceName() + "_dhcp", new ArrayList());
            this.values.put(entry.getInterfaceName() + "_address", entry.getNetworkInterface().getAddress());
            this.messages.put(entry.getInterfaceName() + "_address", new ArrayList());
            this.values.put(entry.getInterfaceName() + "_netmask", entry.getNetworkInterface().getNetmask());
            this.messages.put(entry.getInterfaceName() + "_netmask", new ArrayList());
            this.values.put(entry.getInterfaceName() + "_index", String.valueOf(index));
            this.messages.put(entry.getInterfaceName() + "_index", new ArrayList());
            ++index;
        }
        this.messages.put("hostname", new ArrayList());
        this.messages.put("nameserver1", new ArrayList());
        this.messages.put("nameserver2", new ArrayList());
        this.messages.put("gateway", new ArrayList());
        this.messages.put("bridgedEnabled", new ArrayList());
        this.messages.put("bridgedDhcp", new ArrayList());
        this.messages.put("bridgedAddress", new ArrayList());
        this.messages.put("bridgedNetmask", new ArrayList());
    }

    private void initMSPForm() {
        this.values = new HashMap<String, String>();
        this.values.put("relayHostname", "");
        this.values.put("port", "");
        this.values.put("username", "");
        this.values.put("password", "");
        this.values.put("path", "");
        this.values.put("enabled", "");
        this.values.put("uploadInterval", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("relayHostname", new ArrayList());
        this.messages.put("port", new ArrayList());
        this.messages.put("username", new ArrayList());
        this.messages.put("password", new ArrayList());
        this.messages.put("path", new ArrayList());
        this.messages.put("enabled", new ArrayList());
        this.messages.put("uploadInterval", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initTimesyncForm() {
        this.values = new HashMap<String, String>();
        this.values.put("updateInterval", "");
        this.values.put("timeServer", "");
        this.values.put("enabled", "");
        this.values.put("autoConfig", "");
        this.values.put("timeZone", "");
        this.values.put("day", "");
        this.values.put("month", "");
        this.values.put("year", "");
        this.values.put("hours", "");
        this.values.put("minutes", "");
        this.values.put("fixedDateTime", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("updateInterval", new ArrayList());
        this.messages.put("timeServer", new ArrayList());
        this.messages.put("enabled", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
        this.messages.put("timeZone", new ArrayList());
        this.messages.put("day", new ArrayList());
        this.messages.put("month", new ArrayList());
        this.messages.put("year", new ArrayList());
        this.messages.put("hours", new ArrayList());
        this.messages.put("minutes", new ArrayList());
        this.messages.put("fixedDateTime", new ArrayList());
    }

    private void updateDateTime(DateTimeConfiguration dateTimeConfiguration) {
        dateTimeConfiguration.fixDateTime();
        DateTime dateTime = dateTimeConfiguration.getDateTime();
        this.values.put("day", String.valueOf(dateTime.getDayOfMonth()));
        this.values.put("month", String.valueOf(dateTime.getMonthOfYear()));
        this.values.put("year", String.valueOf(dateTime.getYear()));
        this.values.put("hours", String.valueOf(dateTime.getHourOfDay()));
        this.values.put("minutes", String.valueOf(dateTime.getMinuteOfHour()));
        this.values.put("fixedDateTime", dateTimeConfiguration.getFixedDateTimeString());
    }

    private void initWirelessForm() {
        this.values = new HashMap<String, String>();
        this.values.put("wirelessChannel", "");
        this.values.put("autoConfig", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("wirelessChannel", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initRfPowerForm() {
        this.values = new HashMap<String, String>();
        this.values.put("autoConfig", "");
        this.values.put("rfPower", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("autoConfig", new ArrayList());
        this.messages.put("rfPower", new ArrayList());
    }

    private void initAutoConfigForm() {
        this.values = new HashMap<String, String>();
        this.values.put("autoConfig", "");
        this.values.put("deviceMode", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("autoConfig", new ArrayList());
        this.messages.put("deviceMode", new ArrayList());
    }

    private void initBroadcastForm() {
        this.values = new HashMap<String, String>();
        this.values.put("enabled", "");
        this.values.put("broadcastPort", "");
        this.values.put("broadcastIntervalInMinutes", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("enabled", new ArrayList());
        this.messages.put("broadcastPort", new ArrayList());
        this.messages.put("broadcastIntervalInMinutes", new ArrayList());
        this.messages.put("autoConfig", new ArrayList());
    }

    private void initLFForm() {
        this.values = new HashMap<String, String>();
        this.values.put("enabled", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("enabled", new ArrayList());
    }

    private void initVPNForm(ClientVPNConfiguration vpnConfiguration) {
        this.values = new HashMap<String, String>();
        this.messages = new HashMap<String, List<String>>();
        this.values.put("enabled", String.valueOf(vpnConfiguration.isEnabled()));
        this.values.put("dev", vpnConfiguration.getDevice());
        this.values.put("proto", vpnConfiguration.getProtocol());
        this.values.put("remoteaddress", vpnConfiguration.getRemoteAddress());
        this.values.put("remoteport", vpnConfiguration.getRemotePort());
        this.values.put("verb", vpnConfiguration.getLogLevel());
        this.values.put("ca", vpnConfiguration.getCa());
        this.values.put("cert", vpnConfiguration.getCert());
        this.values.put("key", vpnConfiguration.getKey());
        this.values.put("additionaloptions", vpnConfiguration.getAdditionalOptions().toString());
        this.messages.put("enabled", new ArrayList());
        this.messages.put("dev", new ArrayList());
        this.messages.put("proto", new ArrayList());
        this.messages.put("remoteaddress", new ArrayList());
        this.messages.put("remoteport", new ArrayList());
        this.messages.put("verb", new ArrayList());
        this.messages.put("ca", new ArrayList());
        this.messages.put("cert", new ArrayList());
        this.messages.put("key", new ArrayList());
        this.messages.put("additionaloptions", new ArrayList());
    }

    private void initAPCSettingsForm() {
        this.values = new HashMap<String, String>();
        this.values.put("thinMode", "");
        this.values.put("outboundMode", "");
        this.values.put("apc-address", "");
        this.values.put("apc-port", "");
        this.values.put("tlsEnabled", "");
        this.values.put("tlsStrictVerificationEnabled", "");
        this.messages = new HashMap<String, List<String>>();
        this.messages.put("thinMode", new ArrayList());
        this.messages.put("outboundMode", new ArrayList());
        this.messages.put("apc-address", new ArrayList());
        this.messages.put("apc-port", new ArrayList());
        this.messages.put("tlsEnabled", new ArrayList());
        this.messages.put("tlsStrictVerificationEnabled", new ArrayList());
    }

    public String getFormName() {
        return this.formName;
    }

    public void setValue(String key, String value) {
        if (this.values.containsKey(key)) {
            this.values.put(key, value);
        }
    }

    public void addValue(String key, String value) {
        this.values.put(key, value);
        this.messages.put(key, new ArrayList());
    }

    public String getValue(String key) {
        String value = this.values.get(key);
        return value != null ? value : "";
    }

    public void addMessage(String key, String message) {
        if (this.messages.containsKey(key) && !this.messages.get(key).contains(message)) {
            this.messages.get(key).add(message);
        }
    }

    public Map<String, List<String>> getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        for (String fieldName : this.messages.keySet()) {
            this.messages.get(fieldName).clear();
        }
    }

    public Document toXML(DateTimeConfiguration dateTimeConfiguration) {
        String[] timeZones;
        this.updateDateTime(dateTimeConfiguration);
        Document document = this.toXML();
        Element timeZonesElement = document.createElement("timeZones");
        for (String timeZoneId : timeZones = TimeZone.getAvailableIDs()) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            Element timeZoneElement = document.createElement("timeZone");
            timeZoneElement.setAttribute("value", TimeZoneConfiguration.toTimeZoneString(timeZone));
            timeZoneElement.setAttribute("offset", TimeZoneConfiguration.toOffsetString(timeZone));
            timeZoneElement.setAttribute("rawOffset", String.valueOf(timeZone.getRawOffset()));
            timeZonesElement.appendChild(timeZoneElement);
        }
        document.getDocumentElement().appendChild(timeZonesElement);
        return document;
    }

    public Document toWebserviceXML(int defaultPort) {
        this.addDefaultWebservicePort(defaultPort);
        return this.toXML();
    }

    private void addDefaultWebservicePort(int defaultPort) {
        this.messages.put("defaultPort", new ArrayList());
        this.values.put("defaultPort", String.valueOf(defaultPort));
    }

    public Document toApplianceWebserviceXML(int defaultPort, int webservicePort) {
        this.addDefaultAppliancePort(defaultPort, webservicePort);
        return this.toXML();
    }

    private void addDefaultAppliancePort(int defaultPort, int webservicePort) {
        this.addDefaultWebservicePort(defaultPort);
        this.messages.put("jerseyPort", new ArrayList());
        this.values.put("jerseyPort", String.valueOf(webservicePort));
    }

    public Document toXML() {
        boolean useDefaultTrustStore;
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement(this.formName);
        if (this.formName == WIRELESS_FORM) {
            Element channelsElement = document.createElement("channels");
            for (Enum enum_ : WirelessChannel.values()) {
                Element channelElement = document.createElement("channel");
                channelElement.setAttribute("id", String.valueOf(((WirelessChannel)enum_).getChannelId()));
                channelElement.setAttribute("caption", String.valueOf(((WirelessChannel)enum_).getChannelId()));
                channelElement.setAttribute("frequency", String.format("%.0f", ((WirelessChannel)enum_).getPeakFrequency()));
                channelsElement.appendChild(channelElement);
            }
            root.appendChild(channelsElement);
        } else if (this.formName == LOGGING_FORM) {
            Element logLevelsElement = document.createElement("logLevels");
            for (Enum enum_ : LogLevel.values()) {
                Element logLevelElement = document.createElement("logLevel");
                logLevelElement.setAttribute("id", String.valueOf(enum_.toString()));
                logLevelElement.setAttribute("caption", String.valueOf(enum_.toString()));
                logLevelsElement.appendChild(logLevelElement);
            }
            root.appendChild(logLevelsElement);
        } else if (this.formName == TRUSTSTORE_CONFIGURATION_FORM && !(useDefaultTrustStore = Boolean.valueOf(this.values.get("useDefaultTrustStore")).booleanValue())) {
            try {
                Element trustedCertificatesElement = document.createElement("trusted-certificates");
                new KeyStoreXMLSerializer().trustedCertificatesToXML(document, trustedCertificatesElement, ESLTrustStore.getInstance().getTrustedCertificates());
                root.appendChild(trustedCertificatesElement);
            }
            catch (InitializationException exc) {
                logger.warn("Could not add trusted certificates to web interface: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        for (String key : this.values.keySet()) {
            Element element = document.createElement(key);
            element.setAttribute("value", this.values.get(key));
            if (this.messages.containsKey(key) && this.messages.get(key).size() > 0) {
                element.setAttribute("message", this.messages.get(key).get(0));
            }
            root.appendChild(element);
        }
        document.appendChild(root);
        return document;
    }

    public NetworkConfiguration toNetworkConfiguration() {
        String hostName = this.getValue("hostname");
        boolean dhcp = Boolean.valueOf(this.getValue("dhcp"));
        if (dhcp) {
            return new NetworkConfiguration(hostName);
        }
        return new NetworkConfiguration(hostName, this.getValue("address"), this.getValue("netmask"), this.getValue("gateway"), this.getValue("nameserver1"), this.getValue("nameserver2"));
    }

    public MultiNetworkInterfaceConfiguration toMultiNetworkInterfaceConfiguration() {
        String hostName = this.getValue("hostname");
        String nameServer1 = this.getValue("nameserver1");
        String nameServer2 = this.getValue("nameserver2");
        boolean bridged = Boolean.valueOf(this.getValue("bridgedEnabled"));
        String bridgedAddress = this.getValue("bridgedAddress");
        String bridgedNetmask = this.getValue("bridgedNetmask");
        String gateway = this.getValue("gateway");
        boolean bridgedDhcp = Boolean.valueOf(this.getValue("bridgedDhcp"));
        BridgeNetworkConfiguration bridgeConfiguration = bridged ? (bridgedDhcp ? new BridgeNetworkConfiguration(true) : new BridgeNetworkConfiguration(bridgedAddress, bridgedNetmask)) : new BridgeNetworkConfiguration(false);
        Iterable interfaceNames = Splitter.on((String)",").split((CharSequence)this.getValue("adapternames"));
        ArrayList<NetworkInterfaceConfigurationEntry> networkEntries = new ArrayList<NetworkInterfaceConfigurationEntry>();
        for (String interfaceName : interfaceNames) {
            String address = this.getValue(String.format("%s_address", interfaceName));
            String netmask = this.getValue(String.format("%s_netmask", interfaceName));
            boolean dhcp = Boolean.valueOf(this.getValue(String.format("%s_dhcp", interfaceName)));
            NetworkInterfaceConfiguration interfaceConfiguration = dhcp || bridged ? new NetworkInterfaceConfiguration() : new NetworkInterfaceConfiguration(address, netmask);
            networkEntries.add(new NetworkInterfaceConfigurationEntry(interfaceName, interfaceConfiguration));
        }
        Collections.sort(networkEntries, NetworkInterfaceConfigurationEntry.COMPARATOR);
        return new MultiNetworkInterfaceConfiguration(hostName, networkEntries, gateway, nameServer1, nameServer2, bridgeConfiguration);
    }

    public MSPConfiguration toMSPConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        String hostName = this.getValue("relayHostname");
        String username = this.getValue("username");
        String password = this.getValue("password");
        String path = this.getValue("path");
        int uploadInterval = 0;
        int port = 0;
        try {
            port = Integer.parseInt(this.getValue("port"));
        }
        catch (NumberFormatException exc) {
            port = 21;
        }
        try {
            uploadInterval = Integer.parseInt(this.getValue("uploadInterval"));
        }
        catch (NumberFormatException exc) {
            uploadInterval = 15;
        }
        return new MSPConfiguration(hostName, port, username, password, path, uploadInterval, enabled);
    }

    public TimesyncConfiguration toTimesyncConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        String timeServer = this.getValue("timeServer");
        int updateInterval = 0;
        try {
            updateInterval = Integer.parseInt(this.getValue("updateInterval"));
        }
        catch (NumberFormatException exc) {
            updateInterval = 60;
        }
        return new TimesyncConfiguration(enabled, timeServer, updateInterval);
    }

    public TimeZoneConfiguration toTimeZoneConfiguration() {
        String timeZoneString = this.getValue("timeZone");
        TimeZone timeZone = TimeZoneConfiguration.fromString(timeZoneString);
        return new TimeZoneConfiguration(timeZone);
    }

    public WirelessConfiguration toWirelessConfiguration() {
        String channelString = this.getValue("wirelessChannel");
        if (channelString != null && !channelString.isEmpty()) {
            int channelId = Integer.parseInt(channelString);
            return new WirelessConfiguration(WirelessChannel.getFromId(channelId));
        }
        return new WirelessConfiguration();
    }

    public OutputPower toRfPowerSetting() {
        String rfPowerString = this.getValue("rfPower");
        if (rfPowerString != null && !rfPowerString.isEmpty()) {
            OutputPower rfPowerSetting = OutputPower.valueOf(rfPowerString);
            return rfPowerSetting;
        }
        return OutputPower.DEFAULT_POWER;
    }

    public boolean toAutoConfigConfiguration() {
        return Boolean.valueOf(this.getValue("autConfig"));
    }

    public BroadcastConfiguration toBroadcastConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        int broadcastPort = 0;
        int broadcastIntervalInMinutes = 0;
        try {
            broadcastPort = Integer.valueOf(this.getValue("broadcastPort"));
        }
        catch (NumberFormatException exc) {
            broadcastPort = ESLSystemDefaults.DEFAULT_DISCOVERY_BROADCAST_PORT;
        }
        try {
            broadcastIntervalInMinutes = Integer.valueOf(this.getValue("broadcastIntervalInMinutes"));
        }
        catch (NumberFormatException exc) {
            broadcastIntervalInMinutes = BroadcastConfiguration.DEFAULT_DISCOVERY_BROADCAST_INTERVAL_IN_MINUTES;
        }
        return new BroadcastConfiguration(enabled, broadcastIntervalInMinutes, broadcastPort);
    }

    public LoggingConfiguration toLoggingConfiguration() {
        int socketPort;
        boolean socketAppenderEnabled = Boolean.valueOf(this.getValue("socketAppenderEnabled"));
        String socketRemoteAddress = this.getValue("socketRemoteAddress");
        LogLevel logLevel = LogLevel.parseString(this.getValue("logLevel"));
        try {
            socketPort = Integer.valueOf(this.getValue("socketPort"));
        }
        catch (NumberFormatException exc) {
            socketPort = -1;
        }
        if (socketPort > 0 && socketRemoteAddress != null && !socketRemoteAddress.isEmpty()) {
            return new LoggingConfiguration(logLevel, socketPort, socketRemoteAddress, socketAppenderEnabled);
        }
        return new LoggingConfiguration(logLevel);
    }

    public DateTimeConfiguration toDateTimeConfiguration() {
        String day = this.getValue("day");
        String month = this.getValue("month");
        String year = this.getValue("year");
        String hours = this.getValue("hours");
        String minutes = this.getValue("minutes");
        try {
            DateTime dateTime = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm").parseDateTime(String.format("%s.%s.%s %s:%s", day, month, year, hours, minutes));
            DateTime fixedDateTime = DateTimeConfiguration.parseFixedDateTime(this.getValue("fixedDateTime"));
            return new DateTimeConfiguration(dateTime, fixedDateTime);
        }
        catch (IllegalArgumentException exc) {
            return new DateTimeConfiguration();
        }
    }

    public LowFrequencyDriverConfiguration toLowFrequencyDriverConfiguration() {
        boolean enabled = Boolean.valueOf(this.getValue("enabled"));
        return new LowFrequencyDriverConfiguration(enabled);
    }

    public SSLConfiguration toSSLConfiguration() {
        boolean verifyClientCertificates = Boolean.valueOf(this.getValue("verifyClientCertificates"));
        return new SSLConfiguration(verifyClientCertificates);
    }

    public WebserviceConfiguration toWebserviceConfiguration() {
        boolean httpEnabled = Boolean.valueOf(this.getValue("httpPortEnabled"));
        boolean httpsEnabled = Boolean.valueOf(this.getValue("httpsPortEnabled"));
        String defaultServicePortState = this.getValue("defaultServicePortSSL");
        return new WebserviceConfiguration(httpEnabled, httpsEnabled, WebserviceConfiguration.WebserviceState.valueOf(defaultServicePortState));
    }

    public ApplianceWebserviceConfiguration toApplianceWebserviceConfiguration() {
        boolean httpEnabled = Boolean.valueOf(this.getValue("httpPortEnabled"));
        boolean httpsEnabled = Boolean.valueOf(this.getValue("httpsPortEnabled"));
        String defaultServicePortState = this.getValue("defaultServicePortSSL");
        String webServicePortState = this.getValue("jerseyPortSSL");
        ArrayList disabledInterfaces = Lists.newArrayList();
        if (this.getValue("interfaces") != null) {
            Iterable interfaces = Splitter.on((String)";").split((CharSequence)this.getValue("interfaces"));
            for (String interfaceName : interfaces) {
                boolean enabled = Boolean.valueOf(this.getValue(String.format("%s_interface", interfaceName)));
                if (enabled) continue;
                disabledInterfaces.add(interfaceName);
            }
        }
        return new ApplianceWebserviceConfiguration(httpEnabled, httpsEnabled, WebserviceConfiguration.WebserviceState.valueOf(defaultServicePortState), WebserviceConfiguration.WebserviceState.valueOf(webServicePortState), disabledInterfaces);
    }

    public TrustStoreConfiguration toTrustStoreConfiguration() {
        boolean useDefaultTrustStore = Boolean.valueOf(this.getValue("useDefaultTrustStore"));
        return new TrustStoreConfiguration(useDefaultTrustStore);
    }

    public ServiceLevelConfiguration toServiceLevelConfiguration() {
        int serviceLevel = Integer.valueOf(this.getValue("serviceLevel"));
        return new ServiceLevelConfiguration(serviceLevel);
    }

    public ThinAPConfiguration toThinAPConfiguration(ThinAPConfiguration oldConfiguration) {
        int apcPort = this.getValue("apc-port").isEmpty() ? 7353 : Integer.parseInt(this.getValue("apc-port"));
        return new ThinAPConfiguration(Boolean.valueOf(this.getValue("thinMode")), oldConfiguration.getPort(), Boolean.valueOf(this.getValue("outboundMode")), this.getValue("apc-address"), apcPort, Boolean.valueOf(this.getValue("tlsEnabled")), Boolean.valueOf(this.getValue("tlsStrictVerificationEnabled")));
    }

    public Document toXML(OutputPower maxRadioOutputPowerLevel) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement(this.formName);
        Element rfSettings = document.createElement("rf-settings");
        for (OutputPower rfSetting : OutputPower.getPossibleSettingsFor(maxRadioOutputPowerLevel)) {
            Element rfSettingElement = document.createElement("rf-setting");
            rfSettingElement.setAttribute("id", rfSetting.name());
            rfSettingElement.setAttribute("caption", rfSetting.getDescription());
            rfSettingElement.setAttribute("milliwatts", String.valueOf(rfSetting.getMilliWatts()));
            rfSettingElement.setAttribute("dbm", String.valueOf(rfSetting.getDbm()));
            rfSettings.appendChild(rfSettingElement);
        }
        root.appendChild(rfSettings);
        for (String key : this.values.keySet()) {
            Element element = document.createElement(key);
            element.setAttribute("value", this.values.get(key));
            if (this.messages.get(key).size() > 0) {
                element.setAttribute("message", this.messages.get(key).get(0));
            }
            root.appendChild(element);
        }
        document.appendChild(root);
        return document;
    }
}

