/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LowFrequencyDriverConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfigurationEntry;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNIptablesConfiguration;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.checksum.Digest;
import at.mrdevelopment.toolkit.checksum.MD5;
import com.google.common.base.Joiner;
import java.security.NoSuchAlgorithmException;

public class ConfigurationChangeManager {
    private final Digest md5;

    public ConfigurationChangeManager() throws InitializationException {
        try {
            this.md5 = new MD5();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public <T> boolean hasChanged(T oldObject, T newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null && newObject != null) {
            return true;
        }
        if (oldObject != null && newObject == null) {
            return true;
        }
        return this.compareHashes(this.getHash(oldObject), this.getHash(newObject));
    }

    private <T> String getHash(T object) {
        return this.md5.getChecksum(this.getMessage(object));
    }

    private boolean compareHashes(String hash1, String hash2) {
        return !hash1.equals(hash2);
    }

    private <T> String getMessage(T object) {
        if (object instanceof AutoConfiguration) {
            return this.constructMessage((AutoConfiguration)object);
        }
        if (object instanceof ThinAPConfiguration) {
            return this.constructMessage((ThinAPConfiguration)object);
        }
        if (object instanceof WirelessConfiguration) {
            return this.constructMessage((WirelessConfiguration)object);
        }
        if (object instanceof NetworkConfiguration) {
            return this.constructMessage((NetworkConfiguration)object);
        }
        if (object instanceof TimesyncConfiguration) {
            return this.constructMessage((TimesyncConfiguration)object);
        }
        if (object instanceof MSPConfiguration) {
            return this.constructMessage((MSPConfiguration)object);
        }
        if (object instanceof BroadcastConfiguration) {
            return this.constructMessage((BroadcastConfiguration)object);
        }
        if (object instanceof LoggingConfiguration) {
            return this.constructMessage((LoggingConfiguration)object);
        }
        if (object instanceof LowFrequencyDriverConfiguration) {
            return this.constructMessage((LowFrequencyDriverConfiguration)object);
        }
        if (object instanceof SSLConfiguration) {
            return this.constructMessage((SSLConfiguration)object);
        }
        if (object instanceof ApplianceWebserviceConfiguration) {
            return this.constructMessage((ApplianceWebserviceConfiguration)object);
        }
        if (object instanceof WebserviceConfiguration) {
            return this.constructWebserviceConfigurationMessage((WebserviceConfiguration)object);
        }
        if (object instanceof MultiNetworkInterfaceConfiguration) {
            return this.constructMultiNetworkInterfaceMessage((MultiNetworkInterfaceConfiguration)object);
        }
        if (object instanceof ServiceLevelConfiguration) {
            return this.constructMessage((ServiceLevelConfiguration)object);
        }
        if (object instanceof TrustStoreConfiguration) {
            return this.constructMessage((TrustStoreConfiguration)object);
        }
        if (object instanceof ClientVPNConfiguration) {
            return this.constructMessage((ClientVPNConfiguration)object);
        }
        if (object instanceof ProtectionLevelConfiguration) {
            return this.constructMessage((ProtectionLevelConfiguration)object);
        }
        throw new IllegalArgumentException("Unknown type for change manager");
    }

    private String constructMessage(TrustStoreConfiguration trustStoreConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(trustStoreConfiguration.isUseDefaultTrustStore());
        return sb.toString();
    }

    private String constructMessage(ServiceLevelConfiguration serviceLevelConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(serviceLevelConfiguration.getLevel());
        return sb.toString();
    }

    private String constructMultiNetworkInterfaceMessage(MultiNetworkInterfaceConfiguration networkConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(networkConfiguration.getHostName());
        sb.append(networkConfiguration.getNameServer1());
        sb.append(networkConfiguration.getNameServer2());
        sb.append(networkConfiguration.getGateway());
        sb.append(networkConfiguration.getBridgeConfiguration().getAddress());
        sb.append(networkConfiguration.getBridgeConfiguration().getNetmask());
        sb.append(networkConfiguration.getBridgeConfiguration().isDhcp());
        sb.append(networkConfiguration.getBridgeConfiguration().isEnabled());
        for (NetworkInterfaceConfigurationEntry entry : networkConfiguration.getInterfaces()) {
            sb.append(entry.getInterfaceName());
            sb.append(entry.getNetworkInterface().getAddress());
            sb.append(entry.getNetworkInterface().getNetmask());
            sb.append(entry.getNetworkInterface().isDhcp());
        }
        return sb.toString();
    }

    private String constructWebserviceConfigurationMessage(WebserviceConfiguration webserviceConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(webserviceConfiguration.isHttpPortEnabled());
        sb.append(webserviceConfiguration.isHttpsPortEnabled());
        sb.append((Object)webserviceConfiguration.getDefaultServiceState());
        return sb.toString();
    }

    private String constructMessage(ApplianceWebserviceConfiguration webserviceConfiguration) {
        StringBuilder sb = new StringBuilder(this.constructWebserviceConfigurationMessage(webserviceConfiguration));
        sb.append((Object)webserviceConfiguration.getWebservicePortState());
        sb.append(webserviceConfiguration.hasDisabledInterfaces() ? Joiner.on((String)"").join(webserviceConfiguration.getDisabledInterfaces()) : "");
        return sb.toString();
    }

    private String constructMessage(SSLConfiguration sslConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(sslConfiguration.isVerifyClientCertificates());
        return sb.toString();
    }

    private String constructMessage(LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(lowFrequencyDriverConfiguration.isEnabled());
        return sb.toString();
    }

    private String constructMessage(AutoConfiguration autoConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(autoConfiguration.isEnabled());
        return sb.toString();
    }

    private String constructMessage(ThinAPConfiguration thinAPConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(thinAPConfiguration.isModeEnabled());
        sb.append(thinAPConfiguration.getPort());
        sb.append(thinAPConfiguration.isOutboundModeEnabled());
        sb.append(thinAPConfiguration.getApcAddress());
        sb.append(thinAPConfiguration.getApcPort());
        sb.append(thinAPConfiguration.isTLSEnabled());
        sb.append(thinAPConfiguration.isTLSStrictVerficationEnabled());
        return sb.toString();
    }

    private String constructMessage(WirelessConfiguration wirelessConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)wirelessConfiguration.getMaxRadioOutputPowerLevel());
        sb.append((Object)wirelessConfiguration.getRadioOutputPowerLevel());
        sb.append(wirelessConfiguration.getPayloadSize());
        sb.append(wirelessConfiguration.getWindowSize());
        if (wirelessConfiguration.getChannel() != null) {
            sb.append(wirelessConfiguration.getChannel().getChannelId());
        }
        return sb.toString();
    }

    private String constructMessage(NetworkConfiguration networkConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(networkConfiguration.getHostName());
        sb.append(networkConfiguration.getAddress());
        sb.append(networkConfiguration.getGateway());
        sb.append(networkConfiguration.getNameServer1());
        sb.append(networkConfiguration.getNameServer2());
        sb.append(networkConfiguration.getNetmask());
        sb.append(networkConfiguration.isDhcp());
        return sb.toString();
    }

    private String constructMessage(TimesyncConfiguration timesyncConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(timesyncConfiguration.isEnabled());
        sb.append(timesyncConfiguration.getTimeServer());
        sb.append(timesyncConfiguration.getUpdateInterval());
        return sb.toString();
    }

    private String constructMessage(MSPConfiguration mspConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(mspConfiguration.getHost());
        sb.append(mspConfiguration.getPort());
        sb.append(mspConfiguration.getUsername());
        sb.append(mspConfiguration.getPassword());
        sb.append(mspConfiguration.getPath());
        sb.append(mspConfiguration.isEnabled());
        sb.append(mspConfiguration.getUploadInterval());
        return sb.toString();
    }

    private String constructMessage(BroadcastConfiguration broadcastConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(broadcastConfiguration.isBroadcastEnabled());
        sb.append(broadcastConfiguration.getBroadcastPort());
        sb.append(broadcastConfiguration.getTimeIntervalInMinutes());
        return sb.toString();
    }

    private String constructMessage(LoggingConfiguration loggingConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(loggingConfiguration.getSocketAppenderPort());
        sb.append(loggingConfiguration.getSocketRemoteAddress());
        sb.append(loggingConfiguration.isSocketAppenderEnabled());
        sb.append(loggingConfiguration.getLogLevel().toString());
        return sb.toString();
    }

    private String constructMessage(ClientVPNConfiguration vpnConfiguration) {
        StringBuilder sb = new StringBuilder();
        sb.append(vpnConfiguration.isEnabled());
        sb.append(vpnConfiguration.getDevice());
        sb.append(vpnConfiguration.getProtocol());
        sb.append(vpnConfiguration.getRemoteAddress());
        sb.append(vpnConfiguration.getRemotePort());
        sb.append(vpnConfiguration.getCa());
        sb.append(vpnConfiguration.getCert());
        sb.append(vpnConfiguration.getKey());
        sb.append(vpnConfiguration.getLogLevel());
        sb.append(vpnConfiguration.getConnectionType());
        for (String additionalOption : vpnConfiguration.getAdditionalOptions()) {
            sb.append(additionalOption);
        }
        if (vpnConfiguration instanceof ClientVPNIptablesConfiguration) {
            sb.append(((ClientVPNIptablesConfiguration)vpnConfiguration).getPreroutingDestination());
        }
        sb.append(vpnConfiguration.getCaChecksum());
        sb.append(vpnConfiguration.getCertChecksum());
        sb.append(vpnConfiguration.getKeyChecksum());
        return sb.toString();
    }

    private String constructMessage(ProtectionLevelConfiguration protectionLevelConfiguration) {
        return String.valueOf((Object)protectionLevelConfiguration.getProtectionLevel());
    }
}

