/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.xml.BackendTaskInfoXMLSerializer;
import at.mrdevelopment.esl.xml.MapXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

@Route(route="/service/storage")
public class BackendWebserviceRequestHandler
implements WebserviceRequestHandler {
    private final BackendControl backendControl;
    private final BackendTaskInfoXMLSerializer backendTaskInfoSerializer = new BackendTaskInfoXMLSerializer();
    private final MapXMLSerializer<String, String> mapSerializer = new MapXMLSerializer();

    public BackendWebserviceRequestHandler(BackendControl backendControl) throws InitializationException {
        this.backendControl = backendControl;
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="tasks.xml")
    public void getTasks(WebserviceRequest request, WebserviceResponse response) throws Exception {
        List<BackendTaskInfo> tasks = this.backendControl.getTasks();
        Document document = this.backendTaskInfoSerializer.toXML(tasks);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="configuration.xml")
    public void getConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Map<String, String> configuration = this.backendControl.getConfiguration();
        Document document = this.mapSerializer.toXML(configuration);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

