/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.PlatformConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.config.AbstractApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfigurationEntry;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import com.google.common.base.Joiner;
import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplianceConfigurationXMLSerializer
extends PlatformConfigurationXMLSerializer {
    public Document toXML(AbstractApplianceConfiguration applianceConfiguration) {
        if (applianceConfiguration instanceof ApplianceConfiguration) {
            ApplianceConfiguration configuration = (ApplianceConfiguration)applianceConfiguration;
            Document document = this.xmlToolkit.newDocument();
            Element root = document.createElement("configuration");
            root.appendChild(this.toXML(configuration.getNetworkConfiguration(), document));
            root.appendChild(this.toXML(configuration.getTimesyncConfiguration(), document));
            root.appendChild(this.toXML(configuration.getLoggingConfiguration(), document));
            root.appendChild(this.toXML(configuration.getClientVPNConfiguration(), document));
            root.appendChild(this.toXML(configuration.getServiceLevelConfiguration(), document));
            root.appendChild(this.toXML(configuration.getWebserviceConfiguration(), document));
            document.appendChild(root);
            return document;
        }
        throw new NotImplementedException();
    }

    private Node toXML(MultiNetworkInterfaceConfiguration networkConfiguration, Document document) {
        Element networkElement = document.createElement("network");
        networkElement.setAttribute("bridge-supported", String.valueOf(networkConfiguration.isBridgeSupported()));
        networkElement.setAttribute("gateway", networkConfiguration.getGateway());
        networkElement.setAttribute("hostname", networkConfiguration.getHostName());
        networkElement.setAttribute("nameserver1", networkConfiguration.getNameServer1());
        networkElement.setAttribute("nameserver2", networkConfiguration.getNameServer2());
        networkElement.setAttribute("bridge-enabled", String.valueOf(networkConfiguration.getBridgeConfiguration().isEnabled()));
        networkElement.setAttribute("bridge-dhcp", String.valueOf(networkConfiguration.getBridgeConfiguration().isDhcp()));
        networkElement.setAttribute("bridge-address", networkConfiguration.getBridgeConfiguration().getAddress());
        networkElement.setAttribute("bridge-netmask", networkConfiguration.getBridgeConfiguration().getNetmask());
        for (NetworkInterfaceConfigurationEntry entry : networkConfiguration.getInterfaces()) {
            networkElement.setAttribute(String.format("%s-dhcp", entry.getInterfaceName()), String.valueOf(entry.getNetworkInterface().isDhcp()));
            networkElement.setAttribute(String.format("%s-address", entry.getInterfaceName()), entry.getNetworkInterface().getAddress());
            networkElement.setAttribute(String.format("%s-netmask", entry.getInterfaceName()), entry.getNetworkInterface().getNetmask());
        }
        return networkElement;
    }

    private Node toXML(ClientVPNConfiguration clientVPNConfiguration, Document document) {
        Element vpnElement = document.createElement("vpn");
        vpnElement.setAttribute("enabled", String.valueOf(clientVPNConfiguration.isEnabled()));
        vpnElement.setAttribute("additional-options", Joiner.on((String)";").join(clientVPNConfiguration.getAdditionalOptions()));
        vpnElement.setAttribute("ca", clientVPNConfiguration.getCa());
        vpnElement.setAttribute("cert", clientVPNConfiguration.getCert());
        vpnElement.setAttribute("key", clientVPNConfiguration.getKey());
        vpnElement.setAttribute("log-level", clientVPNConfiguration.getLogLevel());
        vpnElement.setAttribute("device", clientVPNConfiguration.getDevice());
        vpnElement.setAttribute("protocol", clientVPNConfiguration.getProtocol());
        vpnElement.setAttribute("remote-address", clientVPNConfiguration.getRemoteAddress());
        vpnElement.setAttribute("remote-port", clientVPNConfiguration.getRemotePort());
        return vpnElement;
    }

    private Node toXML(ApplianceWebserviceConfiguration webserviceConfiguration, Document document) {
        Element webserviceElement = document.createElement("webservice");
        webserviceElement.setAttribute("default-port", String.valueOf(webserviceConfiguration.isDefaultServicePortEnabled()));
        webserviceElement.setAttribute("default-port-ssl", String.valueOf(webserviceConfiguration.isDefaultServicePortSSL()));
        webserviceElement.setAttribute("http-port", String.valueOf(webserviceConfiguration.isHttpPortEnabled()));
        webserviceElement.setAttribute("https-port", String.valueOf(webserviceConfiguration.isHttpsPortEnabled()));
        webserviceElement.setAttribute("webservice-port", String.valueOf(webserviceConfiguration.isWebservicePortEnabled()));
        webserviceElement.setAttribute("webservice-port-ssl", String.valueOf(webserviceConfiguration.isWebservicePortSSL()));
        return webserviceElement;
    }

    private Element toXML(ServiceLevelConfiguration serviceLevelConfiguration, Document document) {
        Element serviceLevelElement = document.createElement("integration-level");
        serviceLevelElement.setAttribute("level", String.valueOf(serviceLevelConfiguration.getLevel()));
        return serviceLevelElement;
    }
}

