/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.esl.admin.ConfigurationHtmlFormParser;
import at.mrdevelopment.esl.admin.ConfigurationValidator;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.RuntimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.ConfigurationManager;
import at.mrdevelopment.esl.admin.platform.upload.ConfigurationFileUploadExecutor;
import at.mrdevelopment.esl.admin.platform.upload.DefaultSoftwareUploadExecutor;
import at.mrdevelopment.esl.admin.platform.upload.SoftwareUploadExecutor;
import at.mrdevelopment.esl.certificate.CertificateParser;
import at.mrdevelopment.esl.certificate.CertificateProperties;
import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.esl.certificate.ESLTrustStore;
import at.mrdevelopment.esl.certificate.InvalidCertifcateKeyException;
import at.mrdevelopment.esl.xml.KeyStoreXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;

@Route(route="/service/config")
public abstract class AdministrationWebserviceRequestHandler<T extends ConfigurationManager<?>, C extends BackendControl, S extends SystemAttributes>
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(AdministrationWebserviceRequestHandler.class);
    protected final C backendControl;
    protected final T configurationManager;
    protected final S systemAttributes;
    protected final ConfigurationHtmlFormParser htmlFormParser;
    protected final ConfigurationValidator validator;
    protected final XMLToolkit xmlToolkit;
    protected final SoftwareUploadExecutor uploadExecutor;
    protected final KeyStoreXMLSerializer keyStoreSerializer;
    protected final CertificateParser certificateParser;
    protected final RuntimeConfiguration runtimeConfiguration;
    private final ConfigurationFileUploadExecutor configurationUploadExecutor;

    protected AdministrationWebserviceRequestHandler(C backendControl, T configurationManager, S systemAttributes, RuntimeConfiguration runtimeConfiguration) throws InitializationException {
        this.backendControl = backendControl;
        this.configurationManager = configurationManager;
        this.systemAttributes = systemAttributes;
        this.runtimeConfiguration = runtimeConfiguration;
        this.uploadExecutor = new DefaultSoftwareUploadExecutor((BackendControl)backendControl, (SystemAttributes)systemAttributes);
        this.htmlFormParser = new ConfigurationHtmlFormParser();
        this.validator = new ConfigurationValidator();
        this.xmlToolkit = new XMLToolkit();
        this.keyStoreSerializer = new KeyStoreXMLSerializer();
        this.configurationUploadExecutor = new ConfigurationFileUploadExecutor((BackendControl)backendControl);
        this.certificateParser = new CertificateParser();
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/view.xml")
    public void getCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        Document document = this.keyStoreSerializer.certificateToXML(keyStore);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/certificate.pem")
    public void downloadCertificatePEM(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        response.respondPEM(keyStore.getCertificatePEM());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/certificate.der")
    public void downloadCertificateDER(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        response.respondDER(keyStore.getCertificateDER());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/generateCertificate.xml")
    public void generateCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/upload.html")
    public void uploadCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        block11: {
            block10: {
                ByteArrayInputStream inputStream;
                ByteArrayOutputStream outputStream;
                block9: {
                    HttpEntity body = request.getBody();
                    if (!body.getContentType().getValue().contains("multipart/form-data")) break block10;
                    ESLKeyStore keyStore = ESLKeyStore.getInstance();
                    MultipartFileParser parser = new MultipartFileParser();
                    outputStream = null;
                    inputStream = null;
                    try {
                        outputStream = new ByteArrayOutputStream();
                        String fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                        if (fileName != null) {
                            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                            if (FilenameUtils.isExtension((String)fileName, (String)"p12")) {
                                if (request.getRequestParameters().containsKey("password")) {
                                    keyStore.importCertificateContainer(inputStream, (String)request.getRequestParameters().get("password"));
                                    response.respondMessage(String.format("Certificate(s) uploaded", new Object[0]));
                                } else {
                                    response.respondMessage("No password specified for container", 400);
                                }
                                break block9;
                            }
                            if (!FilenameUtils.isExtension((String)fileName.toLowerCase(), (String[])new String[]{"crt", "cer", "der", "pem"})) break block9;
                            try {
                                List<Certificate> certificates = this.certificateParser.parseCertificates(inputStream);
                                if (certificates.size() > 0) {
                                    keyStore.importCertificates(certificates);
                                    response.respondMessage("Certificate uploaded");
                                    break block9;
                                }
                                response.respondMessage(String.format("Could not parse valid certificate from file %s", fileName), 400);
                            }
                            catch (InvalidCertifcateKeyException exc) {
                                response.respondMessage(String.format("Invalid key: %s", exc.getMessage()), 400);
                            }
                            break block9;
                        }
                        response.respondMessage("Could not read certificate.", 400);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.close((OutputStream)outputStream);
                StreamUtils.close((InputStream)inputStream);
                break block11;
            }
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/keypair.xml")
    public void getKeyPair(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondMessage("Not implemented yet");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/keypair.html")
    public void setKeyPair(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondMessage("Not implemented yet");
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/csr.xml")
    public void getCertificateSigningRequest(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        CertificateProperties defaultProperties = keyStore.getDefaultProperties();
        Document document = this.keyStoreSerializer.toXML(defaultProperties);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/csr.pem")
    public void downloadCSRPEM(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        String csrPem = keyStore.getCertificationRequestPEM(keyStore.getDefaultProperties());
        response.respondCSR(csrPem);
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/csr.der")
    public void downloadCSRDER(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        byte[] csrDer = keyStore.getCertificationRequestDER(keyStore.getDefaultProperties());
        response.respondDER(csrDer);
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/generateCertificate.html")
    public void generateSelfSignedCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        keyStore.createAndStoreSelfSignedCertificate(keyStore.getDefaultProperties());
        response.respondMessage("New self-signed certificate generated.", 200);
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="datetime.xml")
    public void getDateTimeSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        TimesyncConfiguration timesyncConfiguration = ((ConfigurationManager)this.configurationManager).getTimesyncConfiguration();
        TimeZoneConfiguration timeZoneConfiguration = ((ConfigurationManager)this.configurationManager).getTimeZoneConfiguration();
        boolean autoConfig = false;
        DateTimeConfiguration dateTimeConfiguration = ((ConfigurationManager)this.configurationManager).getDateTimeConfiguration();
        Document document = new ConfigurationForm(timesyncConfiguration, timeZoneConfiguration, autoConfig).toXML(dateTimeConfiguration);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="datetime.html")
    public void setDateTimeSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm dateTimeForm = this.htmlFormParser.parseDateTimeForm(request.getBody(), false);
        if (this.validator.validate(dateTimeForm)) {
            TimesyncConfiguration timesyncConfiguration = dateTimeForm.toTimesyncConfiguration();
            TimeZoneConfiguration timeZoneConfiguration = dateTimeForm.toTimeZoneConfiguration();
            DateTimeConfiguration dateTimeConfiguration = dateTimeForm.toDateTimeConfiguration();
            if (((ConfigurationManager)this.configurationManager).setTimeConfiguration(dateTimeConfiguration, timeZoneConfiguration, timesyncConfiguration)) {
                response.respondMessage("Date/Time settings updated.");
            } else {
                Document document = dateTimeForm.toXML(((ConfigurationManager)this.configurationManager).getDateTimeConfiguration());
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = dateTimeForm.toXML(((ConfigurationManager)this.configurationManager).getDateTimeConfiguration());
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="logging.xml")
    public void getLoggingSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        LoggingConfiguration loggingConfiguration = ((ConfigurationManager)this.configurationManager).getLoggingConfiguration();
        Document document = new ConfigurationForm(loggingConfiguration, false).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="logging.html")
    public void setLoggingSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm loggingForm = this.htmlFormParser.parseLoggingConfigurationForm(request.getBody(), false);
        if (this.validator.validate(loggingForm)) {
            LoggingConfiguration loggingConfiguration = loggingForm.toLoggingConfiguration();
            if (((ConfigurationManager)this.configurationManager).setLoggingConfiguration(loggingConfiguration)) {
                response.respondMessage("Logging settings updated.");
            } else {
                Document document = loggingForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = loggingForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="truststore.xml")
    public void getTrustStoreSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        TrustStoreConfiguration trustStoreConfiguration = ((ConfigurationManager)this.configurationManager).getTrustStoreConfiguration();
        Document document = new ConfigurationForm(trustStoreConfiguration).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="truststore.html")
    public void setTrustStoreSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm trustStoreForm = this.htmlFormParser.parseTrustStoreConfiguration(request.getBody(), false);
        if (this.validator.validate(trustStoreForm)) {
            TrustStoreConfiguration trustStoreConfiguration = trustStoreForm.toTrustStoreConfiguration();
            if (((ConfigurationManager)this.configurationManager).setTrustStoreConfiguration(trustStoreConfiguration)) {
                response.respondMessage("Truststore settings updated. Restarting service...");
            } else {
                Document document = trustStoreForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = trustStoreForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="webservice.xml")
    public abstract void getWebserviceConfiguration(WebserviceRequest var1, WebserviceResponse var2) throws Exception;

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="webservice.html")
    public abstract void setWebserviceConfiguration(WebserviceRequest var1, WebserviceResponse var2) throws Exception;

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="system/shutdown.xml")
    public void systemShutdown(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.backendControl.initSystemShutdown();
        response.respondMessage("Shutdown initialized.");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="system/reboot.xml")
    public void systemReboot(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.backendControl.initSystemReboot();
        response.respondMessage("Reboot initialized.");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="service/restart.xml")
    public void serviceRestart(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.backendControl.initServiceRestart();
        response.respondMessage("Service restart initialized.");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="service/restore.xml")
    public void serviceRestore(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.backendControl.initRestoreToFactoryDefaultsAndReboot();
        response.respondMessage("Restore to factory default settings initialized. Rebooting device...");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="software/upload.html")
    public void handleSoftwareUpload(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        if (body.getContentType().getValue().contains(HttpContentType.FORM_MULTIPART.getValue())) {
            MultipartFileParser parser = new MultipartFileParser();
            try {
                File file = parser.writeFileFromStream(body, "/opt/esl/backend/uploads");
                this.uploadExecutor.processUploadedFile(file);
                response.respondMessage("Software upload successful. Starting software update...");
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
                response.respondMessage(String.format("Software upload failed. (%s)", exc.getMessage()), 400);
            }
        } else {
            response.respondMessage("Invalid content type.", 400);
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="configuration/upload.html")
    public void handleConfigurationUpload(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        if (body.getContentType().getValue().contains(HttpContentType.FORM_MULTIPART.getValue())) {
            MultipartFileParser parser = new MultipartFileParser();
            try {
                File file = parser.writeFileFromStream(body, "/opt/esl/backend/uploads");
                this.configurationUploadExecutor.processUploadedFile(file);
                response.respondMessage("Configuration upload successful. Applying configuration...");
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
                response.respondMessage(String.format("Configuration upload failed.", new Object[0]), 400);
            }
        } else {
            response.respondMessage("Invalid content type.", 400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/trusted.html")
    public void uploadTrustedCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        block9: {
            block8: {
                ByteArrayInputStream inputStream;
                ByteArrayOutputStream outputStream;
                block7: {
                    HttpEntity body = request.getBody();
                    if (!body.getContentType().getValue().contains("multipart/form-data")) break block8;
                    ESLTrustStore keyStore = ESLTrustStore.getInstance();
                    MultipartFileParser parser = new MultipartFileParser();
                    outputStream = null;
                    inputStream = null;
                    try {
                        outputStream = new ByteArrayOutputStream();
                        String fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                        if (fileName != null) {
                            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                            if (FilenameUtils.isExtension((String)fileName.toLowerCase(), (String[])new String[]{"crt", "cer", "der", "pem"})) {
                                List<Certificate> certificates = this.certificateParser.parseCertificates(inputStream);
                                if (certificates.size() > 0) {
                                    keyStore.importCertificate(FilenameUtils.removeExtension((String)fileName), certificates.get(0));
                                    response.respondMessage("Trusted certificate uploaded");
                                } else {
                                    response.respondMessage(String.format("Could not parse valid certificate from file %s", fileName), 400);
                                }
                            } else {
                                response.respondMessage(String.format("Invalid file extension: %s", FilenameUtils.getExtension((String)fileName)), 400);
                            }
                            break block7;
                        }
                        response.respondMessage("Could not read certificate.", 400);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.close((OutputStream)outputStream);
                StreamUtils.close((InputStream)inputStream);
                break block9;
            }
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/trusted.xml")
    public void getTrustedCertificates(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Document document = this.keyStoreSerializer.trustedCertificatesToXML(ESLKeyStore.getInstance().getTrustedCertificates());
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/deleteTrustedCertificate.html")
    public void deleteTrustedCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        HttpFormParser formParser = new HttpFormParser(body);
        String alias = formParser.getValue("alias");
        ESLTrustStore.getInstance().deleteCertificate(alias);
        response.respondMessage(String.format("Deleted certificate with alias %s", alias));
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

