/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.esl.admin.PlatformConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastMessage;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccessPointConfigurationXMLSerializer
extends PlatformConfigurationXMLSerializer {
    private static final ESLLogger logger = ESLLogger.getLogger(AccessPointConfigurationXMLSerializer.class);
    private static final String THIN_AP_CONFIG = "thinap-config";
    private static final String THIN_AP_MODE_ENABLED = "modeEnabled";
    private static final String THIN_AP_OUTBOUND_MODE_ENABLED = "outboundModeEnabled";
    private static final String THIN_AP_APC_ADDRESS = "apcAddress";
    private static final String THIN_AP_APC_PORT = "apcPort";
    private static final String THIN_AP_TLS_ENABLED = "tlsEnabled";
    private static final String THIN_AP_TLS_STRICT_VERIFICATION_ENABLED = "tlsStrictVerificationEnabled";
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(AccessPointConfiguration accessPointConfiguration) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("configuration");
        root.setAttribute("autoConfig", String.valueOf(accessPointConfiguration.getAutoConfiguration().isEnabled()));
        root.appendChild(this.toXML(accessPointConfiguration.getNetworkConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getWirelessConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getMSPConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getTimesyncConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getBroadcastConfiguration(), document));
        root.appendChild(this.toXML(accessPointConfiguration.getLoggingConfiguration(), document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(WirelessConfiguration transmissionConfiguration, boolean autoConfig) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("wireless-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        Element channelsElement = document.createElement("channels");
        for (WirelessChannel channel : WirelessChannel.values()) {
            Element channelElement = document.createElement("channel");
            channelElement.setAttribute("id", String.valueOf(channel.getChannelId()));
            channelElement.setAttribute("caption", String.valueOf(channel.getChannelId()));
            channelsElement.appendChild(channelElement);
        }
        root.appendChild(channelsElement);
        Element transmissionConfigurationElement = this.toXML(transmissionConfiguration, document);
        if (transmissionConfiguration != null) {
            root.appendChild(transmissionConfigurationElement);
        }
        document.appendChild(root);
        return document;
    }

    public Document toXML(MSPConfiguration mspConfiguration, boolean autoConfig, HashMap<String, List<String>> errors) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("msp-form");
        root.setAttribute("autoConfig", String.valueOf(autoConfig));
        if (errors != null && errors.size() > 0) {
            for (String error : errors.keySet()) {
                root.appendChild(this.toXML(error, errors.get(error), document));
            }
        }
        root.appendChild(this.toXML(mspConfiguration, document));
        document.appendChild(root);
        return document;
    }

    public Document toXML(boolean autoConfig) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("autoConfig-form");
        Element configurationElement = document.createElement("configuration");
        configurationElement.setAttribute("autoConfig", String.valueOf(autoConfig));
        root.appendChild(configurationElement);
        document.appendChild(root);
        return document;
    }

    public AccessPointConfiguration parseXML(InputStream inputStream, ThinAPConfiguration thinAPConfig) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        boolean autoConfigEnabled = Boolean.parseBoolean(root.getAttribute("autoConfig"));
        AutoConfiguration autoConfiguration = autoConfigEnabled ? AutoConfiguration.ENABLED : AutoConfiguration.DISABLED;
        NetworkConfiguration networkConfiguration = null;
        WirelessConfiguration wirelessConfiguration = null;
        MSPConfiguration mspConfiguration = null;
        TimesyncConfiguration timesyncConfiguration = null;
        BroadcastConfiguration broadcastConfiguration = null;
        LoggingConfiguration loggingConfiguration = null;
        ThinAPConfiguration thinAPConfiguration = thinAPConfig;
        NodeList networkNodes = root.getElementsByTagName("network");
        NodeList wirelessNodes = root.getElementsByTagName("wireless");
        NodeList mspNodes = root.getElementsByTagName("msp");
        NodeList timesyncNodes = root.getElementsByTagName("timesync");
        NodeList broadcastNodes = root.getElementsByTagName("broadcast");
        NodeList loggingNodes = root.getElementsByTagName("logging");
        networkConfiguration = networkNodes.getLength() > 0 ? this.parseNetworkInfoXML((Element)networkNodes.item(0)) : new NetworkConfiguration();
        wirelessConfiguration = wirelessNodes.getLength() > 0 ? this.parseTransmissionConfigurationXML((Element)wirelessNodes.item(0)) : new WirelessConfiguration();
        mspConfiguration = mspNodes.getLength() > 0 ? this.parseMSPConfigurationXML((Element)mspNodes.item(0)) : new MSPConfiguration();
        timesyncConfiguration = timesyncNodes.getLength() > 0 ? this.parseTimesyncConfigurationXML((Element)timesyncNodes.item(0)) : new TimesyncConfiguration();
        broadcastConfiguration = broadcastNodes.getLength() > 0 ? this.parseBroadcastConfigurationXML((Element)broadcastNodes.item(0)) : new BroadcastConfiguration();
        loggingConfiguration = loggingNodes.getLength() > 0 ? this.parseLoggingConfigurationXML((Element)loggingNodes.item(0)) : new LoggingConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration, new SSLConfiguration(), new WebserviceConfiguration(), new TrustStoreConfiguration(), thinAPConfiguration, new ProtectionLevelConfiguration());
    }

    public int parseAccessPointSerial(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        return Integer.parseInt(root.getAttribute("serial"));
    }

    private MSPConfiguration parseMSPConfigurationXML(Element mspElement) throws SerializeException {
        try {
            boolean enabled = Boolean.parseBoolean(mspElement.getAttribute("enabled"));
            String hostName = mspElement.getAttribute("relayHostname");
            int port = Integer.parseInt(mspElement.getAttribute("port"));
            String username = mspElement.getAttribute("username");
            String password = mspElement.getAttribute("password");
            String path = mspElement.getAttribute("path");
            int uploadInterval = Integer.parseInt(mspElement.getAttribute("uploadInterval"));
            if (hostName != null && username != null && password != null && path != null) {
                return new MSPConfiguration(hostName, port, username, password, path, uploadInterval, enabled);
            }
            return new MSPConfiguration();
        }
        catch (Exception exc) {
            logger.info("Error parsing MSP configuration. MSP disabled.");
            return new MSPConfiguration();
        }
    }

    private Element toXML(WirelessConfiguration transmissionConfiguration, Document document) {
        Element wirelessElement = document.createElement("wireless");
        if (transmissionConfiguration.getChannel() != null) {
            wirelessElement.setAttribute("channel", Integer.toString(transmissionConfiguration.getChannel().getChannelId()));
        }
        wirelessElement.setAttribute("window-size", Integer.toString(transmissionConfiguration.getWindowSize()));
        wirelessElement.setAttribute("output-power", transmissionConfiguration.getRadioOutputPowerLevel().getDescription());
        return wirelessElement;
    }

    private WirelessConfiguration parseTransmissionConfigurationXML(Element wirelessElement) throws SerializeException {
        try {
            if (wirelessElement.hasAttribute("channel")) {
                int channelId = Integer.parseInt(wirelessElement.getAttribute("channel"));
                return new WirelessConfiguration(WirelessChannel.getFromId(channelId));
            }
            return new WirelessConfiguration();
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Element toXML(MSPConfiguration mspConfiguration, Document document) {
        Element mspElement = document.createElement("msp");
        if (mspConfiguration.getHost() != null) {
            mspElement.setAttribute("relayHostname", mspConfiguration.getHost());
        }
        if (mspConfiguration.getPassword() != null) {
            mspElement.setAttribute("password", mspConfiguration.getPassword());
        }
        if (mspConfiguration.getPath() != null) {
            mspElement.setAttribute("path", mspConfiguration.getPath());
        }
        if (mspConfiguration.getUsername() != null) {
            mspElement.setAttribute("username", mspConfiguration.getUsername());
        }
        mspElement.setAttribute("port", String.valueOf(mspConfiguration.getPort()));
        mspElement.setAttribute("enabled", String.valueOf(mspConfiguration.isEnabled()));
        mspElement.setAttribute("uploadInterval", String.valueOf(mspConfiguration.getUploadInterval()));
        return mspElement;
    }

    private BroadcastConfiguration parseBroadcastConfigurationXML(Element broadcastElement) {
        boolean broadcastEnabled = Boolean.parseBoolean(broadcastElement.getAttribute("enabled"));
        try {
            int broadcastInterval = Integer.parseInt(broadcastElement.getAttribute("broadcastIntervalInMinutes"));
            int broadcastPort = Integer.parseInt(broadcastElement.getAttribute("broadcastPort"));
            return new BroadcastConfiguration(broadcastEnabled, broadcastInterval, broadcastPort);
        }
        catch (Exception exc) {
            return new BroadcastConfiguration(broadcastEnabled);
        }
    }

    private Element toXML(BroadcastConfiguration broadcastConfiguration, Document document) {
        Element broadcastElement = document.createElement("broadcast");
        broadcastElement.setAttribute("enabled", String.valueOf(broadcastConfiguration.isBroadcastEnabled()));
        broadcastElement.setAttribute("broadcastPort", String.valueOf(broadcastConfiguration.getBroadcastPort()));
        broadcastElement.setAttribute("broadcastIntervalInMinutes", String.valueOf(broadcastConfiguration.getTimeIntervalInMinutes()));
        return broadcastElement;
    }

    public Document toBroadcastMessageXML(BroadcastMessage broadcastMessage) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("broadcastMessage");
        root.setAttribute("id", Integer.toString(broadcastMessage.getAccessPointId()));
        root.setAttribute("version", broadcastMessage.getVersion().getVersionString());
        root.setAttribute("autoConfig", Boolean.toString(broadcastMessage.isAutoConfig()));
        root.setAttribute("ssl", Boolean.toString(broadcastMessage.isSsl()));
        root.setAttribute("port", Integer.toString(broadcastMessage.getPort()));
        document.appendChild(root);
        return document;
    }

    public BroadcastMessage parseBroadcastMessageXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        Version version = Version.UNDEFINED;
        try {
            version = Version.fromString((String)root.getAttribute("version"));
            int accessPointId = Integer.parseInt(root.getAttribute("id"));
            boolean autoConfig = Boolean.parseBoolean(root.getAttribute("autoConfig"));
            boolean ssl = Boolean.parseBoolean(root.getAttribute("ssl"));
            int port = Integer.parseInt(root.getAttribute("port"));
            return new BroadcastMessage(accessPointId, autoConfig, version, ssl, port);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public Document toXML(ThinAPConfiguration config) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement(THIN_AP_CONFIG);
        root.setAttribute(THIN_AP_MODE_ENABLED, Boolean.toString(config.isModeEnabled()));
        document.appendChild(root);
        return document;
    }

    public ThinAPConfiguration parseThinAPModeXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        boolean thinModeEnabled = Boolean.parseBoolean(root.getAttribute(THIN_AP_MODE_ENABLED));
        boolean tlsEnabled = root.hasAttribute(THIN_AP_TLS_ENABLED) ? Boolean.valueOf(root.getAttribute(THIN_AP_TLS_ENABLED)) : false;
        boolean tlsStrictVerificationEnabled = root.hasAttribute(THIN_AP_TLS_STRICT_VERIFICATION_ENABLED) ? Boolean.valueOf(root.getAttribute(THIN_AP_TLS_STRICT_VERIFICATION_ENABLED)) : false;
        ThinAPConfiguration thinApConfiguration = root.hasAttribute(THIN_AP_OUTBOUND_MODE_ENABLED) ? new ThinAPConfiguration(thinModeEnabled, 7353, Boolean.parseBoolean(root.getAttribute(THIN_AP_OUTBOUND_MODE_ENABLED)), root.getAttribute(THIN_AP_APC_ADDRESS), Integer.parseInt(root.getAttribute(THIN_AP_APC_PORT)), tlsEnabled, tlsStrictVerificationEnabled) : new ThinAPConfiguration(thinModeEnabled, 7353);
        return thinApConfiguration;
    }

    public Document toThinModeXML(boolean thinApModeEnabled, boolean outboundModeEnabled, String thinApcAddress, int thinApcPort, boolean tlsEnabled) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement(THIN_AP_CONFIG);
        root.setAttribute(THIN_AP_MODE_ENABLED, Boolean.toString(thinApModeEnabled));
        root.setAttribute(THIN_AP_OUTBOUND_MODE_ENABLED, Boolean.toString(outboundModeEnabled));
        root.setAttribute(THIN_AP_APC_ADDRESS, thinApcAddress);
        root.setAttribute(THIN_AP_APC_PORT, Integer.toString(thinApcPort));
        root.setAttribute(THIN_AP_TLS_ENABLED, Boolean.toString(tlsEnabled));
        document.appendChild(root);
        return document;
    }

    public Document createChangePasswordXML() {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("root");
        Element changePasswordElement = document.createElement("changePassword");
        root.appendChild(changePasswordElement);
        document.appendChild(root);
        return document;
    }
}

