/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.core.OutputPower;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.Version;
import java.util.Set;
import java.util.TreeSet;

public class ProtocolSettings {
    public static final Version LABEL_EVENTS_VERSION = Version.fromString((String)"3.0.3");
    public static final Version LEGACY_SLOT_COUNT_VERSION = Version.fromString((String)"3.0.3");
    public static final int LEGACY_SLOT_COUNT = 256;
    public static final int SLOT_COUNT = 1024;
    public static final int SLOT_TIME = 59;
    public static final int SLOT_PIPELINE_SIZE = 16;
    public static final int MAX_JOIN_REQUESTS_PER_SLOT = 5;
    public static final int MAX_LABEL_EVENTS_PER_SLOT = 5;
    public static final int MAX_COMMANDS_PER_SLOT = 3;
    public static final int MAX_DATA_PACKETS_PER_SLOT = 14;
    public static final int MAX_PACKETS_PER_SLOT = 18;
    private final int accessPointId;
    private final int protocolId;
    private final SyncProfile syncProfile;
    private final WirelessConfiguration wirelessConfiguration;
    private final Set<WirelessChannel> usedChannels;
    private final boolean syncEnabled;
    private final boolean identifyModeEnabled;
    private final boolean joinForbidden;

    public ProtocolSettings(int accessPointId, int protocolId, SyncProfile syncProfile, WirelessConfiguration wirelessConfiguration, Set<WirelessChannel> usedChannels, boolean syncEnabled, boolean identifyModeEnabled, boolean joinForbidden) {
        this.accessPointId = accessPointId;
        this.protocolId = protocolId;
        this.syncProfile = syncProfile;
        this.wirelessConfiguration = wirelessConfiguration;
        this.usedChannels = new TreeSet<WirelessChannel>(usedChannels);
        this.syncEnabled = syncEnabled;
        this.identifyModeEnabled = identifyModeEnabled;
        this.joinForbidden = joinForbidden;
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    public WirelessConfiguration getWirelessConfiguration() {
        return this.wirelessConfiguration;
    }

    public int getLogicalChannel() {
        WirelessChannel wirelessChannel = this.wirelessConfiguration.getChannel();
        return wirelessChannel != null ? wirelessChannel.getLogicalChannel() : WirelessChannel.CHANNEL_0.getLogicalChannel();
    }

    public OutputPower getRadioOutputPowerLevel() {
        return this.wirelessConfiguration.getRadioOutputPowerLevel();
    }

    public Set<WirelessChannel> getUsedChannels() {
        return this.usedChannels;
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled && this.wirelessConfiguration.getChannel() != null;
    }

    public boolean isIdentifyModeEnabled() {
        return this.identifyModeEnabled;
    }

    public boolean isJoinForbidden() {
        return this.joinForbidden;
    }
}

