/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.ESLProperties;
import at.mrdevelopment.esl.custom.ConnectorConfiguration;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceOptions;
import at.mrdevelopment.esl.server.Level1Server;
import at.mrdevelopment.esl.server.ServerFactory;
import at.mrdevelopment.esl.server.ServerOptionParser;
import at.mrdevelopment.esl.server.http.DashboardWebserviceRequestHandler;
import at.mrdevelopment.esl.server.http.widget.DatabaseInfoWidget;
import at.mrdevelopment.esl.server.http.widget.DeviceInfoWidget;
import at.mrdevelopment.esl.server.http.widget.LabelStatisticsWidgets;
import at.mrdevelopment.esl.server.http.widget.LabelsOnAccessPointBarWidget;
import at.mrdevelopment.esl.server.http.widget.LicenseStatusWidget;
import at.mrdevelopment.esl.server.http.widget.PluginsWidget;
import at.mrdevelopment.esl.server.http.widget.SeparatorWidget;
import at.mrdevelopment.esl.server.http.widget.ServiceSchedulingWidget;
import at.mrdevelopment.esl.server.http.widget.UpdateStatusPieWidget;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.SystemInfo;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.ArchitectureUtils;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import joptsimple.OptionException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Server {
    public static final String APPLICATION_NAME = "SES-imagotag Core Service";
    private static final String LIB_64_DIRECTORY = "lib-x64";
    private static final String LIB_32_DIRECTORY = "lib-x86";
    static ESLLogger logger;

    public static void main(String[] args) {
        try {
            ServerOptionParser serverOptionParser = new ServerOptionParser(args, Info.load(Server.class), APPLICATION_NAME, ServerFactory.getDefaultServiceLevel());
            int serviceLevel = serverOptionParser.getServiceLevel();
            int listenPort = serverOptionParser.getListenPort();
            DatabaseMaintenanceOptions databaseMaintenanceOptions = serverOptionParser.createDatabaseMaintenanceOptions();
            if (System.getProperty("javax.net.ssl.trustStore") == null) {
                ESLProperties.setTrustStore((boolean)true);
            }
            if (databaseMaintenanceOptions.isShutdownService() || serverOptionParser.getExportFile() != null) {
                System.setProperty("java.awt.headless", "true");
            }
            Server.updateJavaLibraryPath();
            ConnectorConfiguration connectorConfiguration = new ConnectorConfiguration(Server.getXSLForLevel(serviceLevel));
            Level1Server server = new ServerFactory(new ServerStartupSettings(connectorConfiguration, serviceLevel, listenPort, databaseMaintenanceOptions, serverOptionParser.getNetworkInterfaces(), serverOptionParser.getImportFile(), serverOptionParser.getBindAddress())).loadServer(serverOptionParser.getDatabaseConfigFile(), serverOptionParser.isSsl());
            Server.createDashBoard(server);
            if (serverOptionParser.getImportFile() != null) {
                server.importData(serverOptionParser.getImportFile());
            }
            if (databaseMaintenanceOptions.isShutdownService()) {
                databaseMaintenanceOptions.printMessage();
                server.shutdownService();
            } else if (serverOptionParser.getExportFile() != null) {
                server.exportData(serverOptionParser.getExportFile());
                System.out.println("Export finished");
                server.shutdownService();
            } else {
                logger.info("Starting %s, Version %s, Build %d", APPLICATION_NAME, server.getVersion().getVersionString(), server.getVersion().getBuild());
                logger.info("Command line arguments: %s", Arrays.toString(args));
                logger.info("Service integration level: %s", serviceLevel);
                new SystemInfo().log();
                server.start(listenPort, serverOptionParser.isSsl());
                server.startJerseyServer(listenPort, serverOptionParser.isSsl());
            }
        }
        catch (DatasetException exc) {
            logger.error("Could not query database: %s", exc.getMessage());
            Server.fail(exc, true);
        }
        catch (WebserviceException exc) {
            logger.error("Could not start HTTP service: %s", exc.getMessage());
            Server.fail(exc, true);
        }
        catch (InitializationException exc) {
            logger.error("Failed to start ESL service: %s", exc.getMessage());
            Server.fail(exc, true);
        }
        catch (OptionException exc) {
            logger.error("Failed to start ESL service: %s", exc.getMessage());
            Server.fail(exc, true);
        }
        catch (Throwable exc) {
            logger.error("Unknown error during startup of ESL service. See stack trace for details.");
            Server.fail(exc, true);
        }
    }

    private static void updateJavaLibraryPath() throws Exception {
        String libraryPath = ArchitectureUtils.IS_64_BIT ? LIB_64_DIRECTORY : LIB_32_DIRECTORY;
        ArchitectureUtils.addLibraryPath(new File(".", libraryPath).getAbsolutePath());
    }

    private static void createDashBoard(Level1Server server) throws InitializationException {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add(new DatabaseInfoWidget(server.level1));
        widgets.add(new DeviceInfoWidget(server.level1));
        widgets.add(new LicenseStatusWidget(server.level1));
        widgets.add(new PluginsWidget(server));
        widgets.add(new SeparatorWidget());
        widgets.add(new LabelStatisticsWidgets(server.level1));
        widgets.add(new UpdateStatusPieWidget(server.level1));
        widgets.add(new LabelsOnAccessPointBarWidget(server.level1));
        widgets.add(new ServiceSchedulingWidget(server.level1));
        server.level1.registerRequestHandler((WebserviceRequestHandler)new DashboardWebserviceRequestHandler(widgets));
    }

    private static String getXSLForLevel(int serviceLevel) {
        if (serviceLevel == 1) {
            return "/xsl/server-level1.xsl";
        }
        if (serviceLevel == 2) {
            return "/xsl/server-level2.xsl";
        }
        return "/xsl/server-level3.xsl";
    }

    private static void fail(Throwable exc, boolean showTrace) {
        if (showTrace) {
            logger.logException(exc);
        } else {
            logger.logExceptionIfDebugEnabled(exc);
        }
        System.out.println("Failed to start imagotag Core service. See log for details.");
        System.out.println();
        System.exit(1);
    }

    static {
        ESLLogger.initLogger(true);
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(Server.class);
    }
}

