/*
 * Decompiled with CFR 0.152.
 */
package com.imagotag.esl.license;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.ArchitectureUtils;
import com.imagotag.esl.license.LicenseInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.SystemUtils;

public class LicenseManagement {
    static ESLLogger logger = ESLLogger.getLogger(LicenseManagement.class);
    private static final String DESCRIPTION_EXPIRED = "EXPIRED";
    private static final String DESCRIPTION_OUTPUT_ERROR = "OUTPUT_ERROR";
    private static final String DESCRIPTION_VERSION_MISMATCH = "VERSION_MISMATCH";
    private static final String DESCRIPTION_VALID = "VALID";
    private static final String DESCRIPTION_WRONG_ = "WRONG_";
    private static final String DESCRIPTION_DUPLICATE_INDEX = "DUPLICATE_INDEX";
    private static final String LICENSE_BASIC = "BASIC";
    private final String productName;
    private final String envVarInstName;
    private final String productVersion;
    private final String binaryPath;
    private final String binaryHash;
    private TLicenseOs licenseOs;
    private String siteName;
    private String systemSerial;
    private final Map<Integer, LicenseInfo> keys = new HashMap<Integer, LicenseInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateBinaryHash(String binaryPath) {
        String string;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(binaryPath));
            string = DigestUtils.sha256Hex((InputStream)inputStream);
        }
        catch (Exception exc) {
            String string2;
            try {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)inputStream);
            return string2;
        }
        StreamUtils.close((InputStream)inputStream);
        return string;
    }

    public static LicenseManagement onLinux(String productName, String envVarInstName, String siteName, String productVersion, String binaryPath, String binaryHash) {
        return new LicenseManagement(productName, envVarInstName, siteName, productVersion, binaryPath, binaryHash, true);
    }

    public static LicenseManagement onWindows(String productName, String envVarInstName, String siteName, String productVersion, String binaryPath, String binaryHash) {
        return new LicenseManagement(productName, envVarInstName, siteName, productVersion, binaryPath, binaryHash, false);
    }

    public static LicenseManagement onCurrentSystem(String productName, String envVarInstName, String siteName, String productVersion, String linuxBinaryX86Path, String linuxBinaryX86Hash, String linuxBinaryArmPath, String linuxBinaryArmHash, String windowsBinaryPath, String windowsBinaryHash) {
        return SystemUtils.IS_OS_LINUX ? LicenseManagement.onLinux(productName, envVarInstName, siteName, productVersion, ArchitectureUtils.IS_ARCH_ARM ? linuxBinaryArmPath : linuxBinaryX86Path, ArchitectureUtils.IS_ARCH_ARM ? linuxBinaryArmHash : linuxBinaryX86Hash) : LicenseManagement.onWindows(productName, envVarInstName, siteName, productVersion, windowsBinaryPath, windowsBinaryHash);
    }

    private LicenseManagement(String productName, String envVarInstName, String siteName, String productVersion, String binaryPath, String binaryHash, boolean isLinux) {
        String binaryPathFromEnv = System.getenv("LANCOM_LICENSE_PATH");
        String binaryHashFromEnv = System.getenv("LANCOM_LICENSE_HASH");
        this.productName = productName;
        this.envVarInstName = envVarInstName;
        this.siteName = siteName;
        this.productVersion = productVersion;
        this.binaryPath = binaryPathFromEnv != null ? binaryPathFromEnv : binaryPath;
        this.binaryHash = binaryHashFromEnv != null ? binaryHashFromEnv : binaryHash;
        this.licenseOs = isLinux ? TLicenseOs.LINUX : TLicenseOs.WINDOWS;
    }

    public synchronized void setSiteName(String siteName) {
        this.siteName = siteName;
        this.systemSerial = null;
    }

    public synchronized List<LicenseInfo> getKeys() {
        return new ArrayList<LicenseInfo>(this.keys.values());
    }

    private LicenseInfo createLicenseInfo(String key) {
        if (!this.checkLicenseExecutable()) {
            return new LicenseInfo(key, false, DESCRIPTION_OUTPUT_ERROR, -1L, -1L, "N/A", -1, -1, null);
        }
        String[] exec = this.license(String.format("-c %s %s", key, this.productVersion));
        if (exec.length == 1 && exec[0].toLowerCase().contains("invalid")) {
            logger.warn("invalid key, wrong context or hardware");
            return new LicenseInfo(key, false, DESCRIPTION_WRONG_ + this.envVarInstName, -1L, -1L, "N/A", -1, -1, null);
        }
        if (exec.length >= 5) {
            try {
                String typeString = exec[0];
                LicenseInfo.Type type = typeString.contains(LICENSE_BASIC) ? LicenseInfo.Type.BASIC : LicenseInfo.Type.EXT;
                boolean isValid = !exec[0].toLowerCase().contains("invalid");
                int index = Integer.parseInt(exec[1]);
                int deviceCount = Integer.parseInt(exec[2]);
                long unlockedDate = System.currentTimeMillis();
                long expireDate = Long.parseLong(exec[3]) * 1000L;
                String productVersion = exec[4];
                String description = DESCRIPTION_VALID;
                if (unlockedDate > expireDate) {
                    description = DESCRIPTION_EXPIRED;
                    isValid = false;
                }
                if (new ComparatorVersionString().compare(productVersion, productVersion) < 0) {
                    description = DESCRIPTION_VERSION_MISMATCH;
                    isValid = false;
                }
                return new LicenseInfo(key, isValid, description, unlockedDate, expireDate, productVersion, index, deviceCount, type);
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
                return new LicenseInfo(key, false, DESCRIPTION_OUTPUT_ERROR, -1L, -1L, "N/A", -1, -1, null);
            }
        }
        return new LicenseInfo(key, false, DESCRIPTION_OUTPUT_ERROR, -1L, -1L, "N/A", -1, -1, null);
    }

    private boolean checkLicenseExecutable() {
        String hash = LicenseManagement.calculateBinaryHash(this.binaryPath);
        logger.debug("License binary hash is %s", new Object[]{hash});
        return hash != null ? hash.equalsIgnoreCase(this.binaryHash) : false;
    }

    public List<LicenseInfo> getValidKeys() {
        ArrayList<LicenseInfo> validKeys = new ArrayList<LicenseInfo>();
        long currentTime = System.currentTimeMillis();
        for (LicenseInfo licenseInfo : this.getKeys()) {
            if (!licenseInfo.isValid() || licenseInfo.getExpirationDate() <= currentTime) continue;
            validKeys.add(licenseInfo);
        }
        return validKeys;
    }

    public boolean isValid(String licenseKey) {
        LicenseInfo licenseInfo = this.createLicenseInfo(licenseKey);
        if (!licenseInfo.isValid()) {
            logger.warn("License key is invalid\n\t%s", new Object[]{licenseInfo.toString()});
            return false;
        }
        if (this.keys.containsKey(licenseInfo.getIndex())) {
            logger.warn("Duplicate license index\n\t%s", new Object[]{licenseInfo.toString()});
            return false;
        }
        return true;
    }

    public synchronized LicenseInfo addKey(String licenseKey) {
        LicenseInfo licenseInfo = this.createLicenseInfo(licenseKey);
        if (licenseInfo != null) {
            if (!this.keys.containsKey(licenseInfo.getIndex())) {
                this.keys.put(licenseInfo.getIndex(), licenseInfo);
            } else {
                return new LicenseInfo(licenseKey, false, DESCRIPTION_DUPLICATE_INDEX, -1L, -1L, "N/A", -1, -1, null);
            }
        }
        return licenseInfo;
    }

    public synchronized void clearKeys() {
        this.keys.clear();
    }

    public synchronized String getSystemSerial() {
        if (this.systemSerial == null) {
            this.systemSerial = this.genSystemSerial();
        }
        return this.systemSerial;
    }

    private String genSystemSerial() {
        String[] execResult;
        String serial = "SERIAL_ERROR";
        if (this.checkLicenseExecutable() && (execResult = this.license("-s " + this.productName)) != null && execResult.length > 0) {
            serial = execResult[0];
        }
        logger.info("Generated LANCOM system serial is %s", new Object[]{serial});
        return serial;
    }

    public int getLicensedDevicesCount() {
        int sum = 0;
        for (LicenseInfo licenseInfo : this.getValidKeys()) {
            sum += licenseInfo.getDeviceCount();
        }
        return sum;
    }

    public boolean isExpired() {
        LicenseInfo basicLicense = this.getBasicLicense();
        if (basicLicense != null) {
            return this.expiresInMillis() > basicLicense.getExpirationDate();
        }
        return true;
    }

    public long expiresInDays() {
        return this.expiresInMillis() / 1000L / 60L / 60L / 24L;
    }

    public long expiresInMillis() {
        LicenseInfo basicLicense = this.getBasicLicense();
        if (basicLicense != null) {
            return basicLicense.getExpirationDate() - System.currentTimeMillis();
        }
        return 0L;
    }

    public LicenseInfo getBasicLicense() {
        for (LicenseInfo licenseInfo : this.getValidKeys()) {
            if (licenseInfo.getType() != LicenseInfo.Type.BASIC) continue;
            return licenseInfo;
        }
        return null;
    }

    public TLicenseOs getLicenseOs() {
        return this.licenseOs;
    }

    public String maxSupportedVersion() {
        List<LicenseInfo> keys = this.getValidKeys();
        if (keys.size() < 1) {
            return null;
        }
        Collections.sort(keys, new ComparatorLicenseInfoByVersion());
        return keys.get(keys.size() - 1).getProductVersion();
    }

    private String cmd(String cmd) {
        StringBuilder builder = new StringBuilder(256);
        String[] cmds = new String[]{this.licenseOs.cmd, this.licenseOs.cmdCloseShell, cmd};
        try {
            String[] envParam = new String[]{this.envVarInstName + "=" + this.siteName};
            Process child = Runtime.getRuntime().exec(cmds, envParam);
            BufferedReader in = new BufferedReader(new InputStreamReader(child.getInputStream()));
            String line = in.readLine();
            do {
                builder.append(line);
                builder.append(this.licenseOs.newLine);
            } while ((line = in.readLine()) != null);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return builder.toString();
    }

    private String[] license(String params) {
        String command = String.format("%s %s", this.binaryPath, params);
        logger.debug("Executing %s", new Object[]{command});
        String result = this.cmd(command);
        logger.debug("Result %s", new Object[]{result});
        return result.split(this.licenseOs.newLine);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.keys.size() == 0) {
            return "No valid keys in this entity.";
        }
        for (LicenseInfo licenseInfo : this.keys.values()) {
            builder.append(licenseInfo.toString()).append(this.licenseOs.newLine);
        }
        return builder.toString();
    }

    public static class ComparatorVersionString
    implements Comparator<String> {
        @Override
        public int compare(String ver1, String ver2) {
            int i;
            if (ver1 == null && ver2 == null) {
                return 0;
            }
            if (ver1 == null) {
                return -1;
            }
            if (ver2 == null) {
                return 1;
            }
            String[] vers1 = ver1.split("\\.");
            String[] vers2 = ver2.split("\\.");
            for (i = 0; i < vers1.length && i < vers2.length && vers1[i].equals(vers2[i]); ++i) {
            }
            if (i < vers1.length && i < vers2.length) {
                int diff = Integer.valueOf(vers1[i]).compareTo(Integer.valueOf(vers2[i]));
                return Integer.signum(diff);
            }
            return Integer.signum(vers1.length - vers2.length);
        }
    }

    public static class ComparatorLicenseInfoByVersion
    implements Comparator<LicenseInfo> {
        ComparatorVersionString comparator = new ComparatorVersionString();

        @Override
        public int compare(LicenseInfo o1, LicenseInfo o2) {
            return this.comparator.compare(o1.getProductVersion(), o2.getProductVersion());
        }
    }

    public static enum TLicenseOs {
        LINUX(new File("/bin/bash").exists() ? "bash" : "sh", "-c", "\n"),
        WINDOWS("cmd", "/C", "\r\n");

        String cmd;
        String cmdCloseShell;
        String newLine;

        private TLicenseOs(String cmd, String cmdCloseShell, String newLine) {
            this.cmd = cmd;
            this.cmdCloseShell = cmdCloseShell;
            this.newLine = newLine;
        }
    }
}

