/*
 * Decompiled with CFR 0.152.
 */
package com.imagotag.esl.license;

import com.google.common.base.Objects;
import java.util.Date;

public class LicenseInfo {
    private final String key;
    private final boolean valid;
    private final String description;
    private final long unlockedDate;
    private final long expirationDate;
    private final String productVersion;
    private final int index;
    private final int deviceCount;
    private final Type type;

    protected LicenseInfo(String key, boolean valid, String description, long unlockedDate, long expirationDate, String productVersion, int index, int deviceCount, Type type) {
        this.key = key;
        this.valid = valid;
        this.description = description;
        this.unlockedDate = unlockedDate;
        this.expirationDate = expirationDate;
        this.productVersion = productVersion;
        this.index = index;
        this.deviceCount = deviceCount;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getDescription() {
        return this.description;
    }

    public long getUnlockedDate() {
        return this.unlockedDate;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public Date getExpirationDateAsDate() {
        return new Date(this.expirationDate);
    }

    public Date getUnlockedDateAsDate() {
        return new Date(this.unlockedDate);
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("Key: " + this.key).append("\n");
        builder.append("\tIs Valid: " + this.valid).append("\n");
        builder.append("\tDescription: " + this.description).append("\n");
        builder.append("\tUnlocked Date: " + this.unlockedDate).append("\n");
        builder.append("\tExpiration Date: " + new Date(this.expirationDate).toString()).append("\n");
        builder.append("\tProduct Version: " + this.productVersion).append("\n");
        builder.append("\tIndex: " + this.index).append("\n");
        builder.append("\tDevice Count: " + this.deviceCount).append("\n");
        builder.append("\tType: " + (Object)((Object)this.type)).append("\n");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LicenseInfo) {
            LicenseInfo rhs = (LicenseInfo)obj;
            String rhs_key = rhs != null ? rhs.key : null;
            String lhs_key = this.key;
            return Objects.equal((Object)lhs_key, (Object)rhs_key);
        }
        return super.equals(obj);
    }

    public static enum Type {
        BASIC,
        EXT;

    }
}

