/*
 * Decompiled with CFR 0.152.
 */
package com.imagotag.esl.license;

import at.mrdevelopment.esl.licencing.FeatureMode;
import at.mrdevelopment.esl.licencing.LicenseReader;
import at.mrdevelopment.esl.type.LicenceContent;
import at.mrdevelopment.esl.type.LicencedFeature;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.imagotag.esl.license.LegacyWhitelist;
import com.imagotag.esl.license.LicenseInfo;
import com.imagotag.esl.license.LicenseManagement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class LancomLicenseReader
implements LicenseReader {
    static ESLLogger logger = ESLLogger.getLogger(LancomLicenseReader.class);
    private static final String VERSION = "1.0";
    private static final String PRODUCT_NAME = "EPE";
    private static final String PARAM_ENV_SITE = "EPE_SITE";
    private static final String DEFAULT_LICENSE_PATH_LINUX_X86 = "./License";
    private static final String DEFAULT_LICENSE_PATH_LINUX_ARM = "./LicenseArm";
    private static final String DEFAULT_LICENSE_PATH_WINDOWS = ".\\License.exe";
    private static final String DEFAULT_LICENSE_HASH_LINUX_X86 = "875602d5889f0442cd29910a45df19356ddcd3fab006b97a9296c4c5409633d3";
    private static final String DEFAULT_LICENSE_HASH_LINUX_ARM = "9c0d49b65c58c28237207a46ed48c8c6c3ae233c412a966e0881f02ceb6f27a7";
    private static final String DEFAULT_LICENSE_HASH_WINDOWS = "62e204a13334f4cf3e09afdb92a81d8e54e3c5fdeaa5a49565b98824e08967cc";
    private final LicenseManagement licenseManagement;

    public static void main(String[] args) {
        System.out.println("./License: " + LicenseManagement.calculateBinaryHash(DEFAULT_LICENSE_PATH_LINUX_X86));
        System.out.println("./LicenseArm: " + LicenseManagement.calculateBinaryHash(DEFAULT_LICENSE_PATH_LINUX_ARM));
        System.out.println(".\\License.exe: " + LicenseManagement.calculateBinaryHash(DEFAULT_LICENSE_PATH_WINDOWS));
    }

    public LancomLicenseReader(String siteName) {
        this.licenseManagement = LicenseManagement.onCurrentSystem(PRODUCT_NAME, PARAM_ENV_SITE, siteName, VERSION, DEFAULT_LICENSE_PATH_LINUX_X86, DEFAULT_LICENSE_HASH_LINUX_X86, DEFAULT_LICENSE_PATH_LINUX_ARM, DEFAULT_LICENSE_HASH_LINUX_ARM, DEFAULT_LICENSE_PATH_WINDOWS, DEFAULT_LICENSE_HASH_WINDOWS);
    }

    public void reset() {
        this.licenseManagement.clearKeys();
    }

    public void setSiteName(String siteName) {
        this.licenseManagement.setSiteName(siteName);
    }

    public String getDefaultSystemSerial() {
        return this.licenseManagement.getSystemSerial();
    }

    public Iterable<String> getAllSystemSerials() {
        return Collections.singleton(this.getDefaultSystemSerial());
    }

    public boolean isValidLicense(String licenseKey) {
        return this.licenseManagement.isValid(licenseKey);
    }

    public LicenceContent processLicense(String licenseKey) throws SerializeException {
        logger.info("Processing license key %s", new Object[]{licenseKey});
        HashSet<LicencedFeature> features = new HashSet<LicencedFeature>();
        LicenseInfo licenseInfo = this.licenseManagement.addKey(licenseKey);
        if (licenseInfo != null && licenseInfo.isValid()) {
            if (licenseInfo.getType() == LicenseInfo.Type.BASIC) {
                int deviceCount = licenseInfo.getDeviceCount();
                int version = this.getDeviceCountVersion(deviceCount);
                if (version == 0) {
                    features.add(new LicencedFeature("mode", FeatureMode.OEM_LANCOM.toString()));
                    features.add(new LicencedFeature("add-allowed-access-points", this.getMaxAllowedAccessPoints(deviceCount)));
                    features.add(new LicencedFeature("add-allowed-labels", this.getMaxAllowedLabels(deviceCount)));
                    features.add(new LicencedFeature("serial-number", licenseInfo.getIndex()));
                } else {
                    logger.warn("Ignoring key %s: Unknown device count version", new Object[]{licenseKey});
                }
            } else {
                logger.warn("Ignoring license key %s: Unsupported type %s", new Object[]{licenseKey, licenseInfo.getType()});
            }
        } else {
            logger.warn("License key %s is invalid (%s)", new Object[]{licenseKey, licenseInfo.getDescription()});
        }
        return new LicenceContent(LegacyWhitelist.WHITELIST, features);
    }

    private int getDeviceCountVersion(int deviceCount) {
        return (deviceCount & 0xFC00) >> 10;
    }

    private int getMaxAllowedAccessPoints(int deviceCount) {
        int apCount = (deviceCount & 0x3E0) >> 5;
        logger.info("apCount = %d", new Object[]{apCount});
        return this.getMaxAllowedDevices(apCount);
    }

    private int getMaxAllowedLabels(int deviceCount) {
        int labelCount = deviceCount & 0x1F;
        logger.info("labelCount = %d", new Object[]{labelCount});
        return this.getMaxAllowedDevices(labelCount);
    }

    private int getMaxAllowedDevices(int deviceCount) {
        switch (deviceCount) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 20;
            }
            case 6: {
                return 25;
            }
            case 7: {
                return 50;
            }
            case 8: {
                return 100;
            }
            case 9: {
                return 200;
            }
            case 10: {
                return 250;
            }
            case 11: {
                return 500;
            }
            case 12: {
                return 1000;
            }
            case 13: {
                return 2000;
            }
            case 14: {
                return 2500;
            }
            case 15: {
                return 5000;
            }
            case 16: {
                return 10000;
            }
            case 17: {
                return 20000;
            }
            case 18: {
                return 25000;
            }
            case 19: {
                return 50000;
            }
            case 20: {
                return 100000;
            }
            case 21: {
                return 200000;
            }
            case 22: {
                return 250000;
            }
            case 23: {
                return 500000;
            }
            case 24: {
                return 1000000;
            }
            case 25: {
                return 2000000;
            }
            case 26: {
                return 2500000;
            }
            case 27: {
                return 5000000;
            }
            case 28: {
                return 10000000;
            }
            case 29: {
                return 20000000;
            }
            case 30: {
                return 25000000;
            }
            case 31: {
                return 50000000;
            }
        }
        return 0;
    }

    public Map<String, String> getAdditionalServiceStatusEntries() {
        return Collections.emptyMap();
    }
}

