/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.advanced.type;

import at.mrdevelopment.esl.custom.jersey.advanced.type.ESLLabelDataPagedResult;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelData")
@XmlRootElement(name="LabelData")
public class ESLLabelData {
    @XmlElement(required=true)
    public String LabelId;
    @XmlElement(required=true)
    public Integer DataId;
    @XmlElement(required=true)
    public String DataType;
    @XmlElement
    public Integer Value;

    public static ESLLabelDataPagedResult wrap(QueryResult<LabelDetail> queryResult) throws MappingException {
        return (ESLLabelDataPagedResult)ESLWrapper.wrapPaged(queryResult, LabelDetail.class, ESLLabelData.class, ESLLabelDataPagedResult.class);
    }

    public static ESLLabelData fromLabelDetail(LabelDetail labelData) {
        ESLLabelData wrapper = new ESLLabelData();
        wrapper.LabelId = labelData.getLabelIdString();
        wrapper.DataId = labelData.getDataId();
        wrapper.DataType = labelData.getType().name();
        wrapper.Value = labelData.getValue();
        return wrapper;
    }

    public static ESLLabelData newExample() {
        ESLLabelData example = new ESLLabelData();
        example.LabelId = "B1001C4A";
        example.DataId = 1;
        example.DataType = LabelDetailType.QUERY_COUNTER.name();
        example.Value = 5;
        return example;
    }
}

