/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.advanced.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.advanced.type.ESLLabelData;
import at.mrdevelopment.esl.custom.jersey.advanced.type.ESLLabelDataList;
import at.mrdevelopment.esl.custom.jersey.advanced.type.ESLLabelDataPagedResult;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.tasks.GetConfigTask;
import at.mrdevelopment.esl.tasks.QueryCounterTask;
import at.mrdevelopment.esl.tasks.QuerySensorTask;
import at.mrdevelopment.esl.tasks.ResetAllCountersTask;
import at.mrdevelopment.esl.tasks.ResetCounterTask;
import at.mrdevelopment.esl.tasks.SetConfigTask;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/labeldata")
@Produces(value={"application/xml", "application/json"})
public class LabelDetailResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    @Path(value="counter/{label}/{dataId}")
    public ESLLabelData getLabelCounter(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label, @PathParam(value="dataId") Integer dataId) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validatePage((Integer)dataId);
        try {
            return this.getLabelDataForQuery(label, dataId, "labeldetail/counter/latest/label", page, recordsPerPage);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="sensor/{label}/{dataId}")
    public ESLLabelData getLabelSensor(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label, @PathParam(value="dataId") Integer dataId) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validatePage((Integer)dataId);
        try {
            return this.getLabelDataForQuery(label, dataId, "labeldetail/sensor/latest/label", page, recordsPerPage);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="config/{label}/{dataId}")
    public ESLLabelData getLabelConfig(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label, @PathParam(value="dataId") Integer dataId) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validatePage((Integer)dataId);
        try {
            return this.getLabelDataForQuery(label, dataId, "labeldetail/config/latest/label", page, recordsPerPage);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private ESLLabelData getLabelDataForQuery(String label, Integer dataId, String query, Integer page, Integer recordsPerPage) throws DatasetException, SerializeException {
        DatasetQuery datasetQuery = this.eslInterface.getQuery(query);
        QueryResult queryResult = this.eslInterface.executeQuery(datasetQuery, QueryRestriction.newSearchQuery(LabelId.class, (Object)LabelId.fromString((String)label), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
        for (LabelDetail record : queryResult.getRecords()) {
            if (!record.getDataId().equals(dataId)) continue;
            return ESLLabelData.fromLabelDetail(record);
        }
        return null;
    }

    @GET
    @Path(value="counters/{label}")
    public ESLLabelDataPagedResult getLabelCountersForLabel(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labeldetail/counter/latest/label");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LabelId.class, (Object)LabelId.fromString((String)label), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelData.wrap((QueryResult<LabelDetail>)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="sensors/{label}")
    public ESLLabelDataPagedResult getLabelSensorsForLabel(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labeldetail/sensor/latest/label");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LabelId.class, (Object)LabelId.fromString((String)label), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelData.wrap((QueryResult<LabelDetail>)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="configs/{label}")
    public ESLLabelDataPagedResult getLabelConfigsForLabel(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String label) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labeldetail/config/latest/label");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LabelId.class, (Object)LabelId.fromString((String)label), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelData.wrap((QueryResult<LabelDetail>)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="query")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction queryLabelData(ESLLabelDataList labelDataList) {
        JerseyValidationUtils.validateNotNull((Object)labelDataList);
        try {
            List partitions;
            HashMap counters = new HashMap();
            HashMap sensors = new HashMap();
            HashMap configs = new HashMap();
            for (ESLLabelData data : labelDataList.List) {
                LabelId label = LabelId.fromString((String)data.LabelId);
                if (data.DataType.equals(LabelDetailType.QUERY_COUNTER.name())) {
                    if (!counters.containsKey(label)) {
                        counters.put(label, new ArrayList());
                    }
                    ((List)counters.get(label)).add(LabelCounter.fromId((int)data.DataId));
                    continue;
                }
                if (data.DataType.equals(LabelDetailType.QUERY_SENSOR.name())) {
                    if (!sensors.containsKey(label)) {
                        sensors.put(label, new ArrayList());
                    }
                    ((List)sensors.get(label)).add(LabelSensor.fromId((int)data.DataId));
                    continue;
                }
                if (!data.DataType.equals(LabelDetailType.GET_CONFIG.name())) continue;
                if (!configs.containsKey(label)) {
                    configs.put(label, new ArrayList());
                }
                ((List)configs.get(label)).add(LabelConfig.fromId((int)data.DataId));
            }
            ArrayList<Object> taskList = new ArrayList<Object>();
            for (Map.Entry entry : counters.entrySet()) {
                partitions = Lists.partition((List)((List)entry.getValue()), (int)2);
                for (List partition : partitions) {
                    taskList.add(new QueryCounterTask((LabelId)entry.getKey(), TaskPriority.LOW, 0L, false, (Collection)partition));
                }
            }
            for (Map.Entry entry : sensors.entrySet()) {
                partitions = Lists.partition((List)((List)entry.getValue()), (int)2);
                for (List partition : partitions) {
                    taskList.add(new QuerySensorTask((LabelId)entry.getKey(), TaskPriority.LOW, 0L, false, (Collection)partition));
                }
            }
            for (Map.Entry entry : configs.entrySet()) {
                partitions = Lists.partition((List)((List)entry.getValue()), (int)1);
                for (List partition : partitions) {
                    taskList.add(new GetConfigTask((LabelId)entry.getKey(), TaskPriority.LOW, 0L, false, (Collection)partition));
                }
            }
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(new TaskOrder(taskList)));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="configure")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction configureLabel(ESLLabelDataList labelDataList) {
        JerseyValidationUtils.validateNotNull((Object)labelDataList);
        try {
            HashMap configs = new HashMap();
            for (ESLLabelData data : labelDataList.List) {
                LabelId label = LabelId.fromString((String)data.LabelId);
                if (!data.DataType.equals(LabelDetailType.SET_CONFIG.name())) continue;
                if (!configs.containsKey(label)) {
                    configs.put(label, new HashMap());
                }
                ((Map)configs.get(label)).put(LabelConfig.fromId((int)data.DataId), data.Value);
            }
            ArrayList<SetConfigTask> taskList = new ArrayList<SetConfigTask>();
            for (Map.Entry entry : configs.entrySet()) {
                for (Map.Entry configEntry : ((Map)entry.getValue()).entrySet()) {
                    taskList.add(new SetConfigTask((LabelId)entry.getKey(), TaskPriority.LOW, 0L, false, (Map)ImmutableMap.builder().put(configEntry).build()));
                }
            }
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(new TaskOrder(taskList)));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="counters/reset")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction resetLabelCounters(ESLLabelDataList labelDataList) {
        JerseyValidationUtils.validateNotNull((Object)labelDataList);
        try {
            HashMap counters = new HashMap();
            for (ESLLabelData data : labelDataList.List) {
                LabelId label = LabelId.fromString((String)data.LabelId);
                if (!data.DataType.equals(LabelDetailType.QUERY_COUNTER.name())) continue;
                if (!counters.containsKey(label)) {
                    counters.put(label, new ArrayList());
                }
                ((List)counters.get(label)).add(LabelCounter.fromId((int)data.DataId));
            }
            ArrayList<ResetCounterTask> taskList = new ArrayList<ResetCounterTask>();
            for (Map.Entry entry : counters.entrySet()) {
                List partitions = Lists.partition((List)((List)entry.getValue()), (int)2);
                for (List partition : partitions) {
                    taskList.add(new ResetCounterTask((LabelId)entry.getKey(), TaskPriority.LOW, 0L, false, (Collection)partition));
                }
            }
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(new TaskOrder(taskList)));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="counters/reset/all")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction resetAllLabelCounters(ESLLabelList labelList) {
        JerseyValidationUtils.validateNotNull((Object)labelList);
        try {
            List labelIds = labelList.toLabelIds();
            ArrayList<ResetAllCountersTask> taskList = new ArrayList<ResetAllCountersTask>();
            for (LabelId labelId : labelIds) {
                taskList.add(new ResetAllCountersTask(labelId, TaskPriority.LOW, 0L, false));
            }
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(new TaskOrder(taskList)));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="task/{taskId}")
    @Produces(value={"application/xml", "application/json"})
    public ESLLabelDataPagedResult getLabelData(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="taskId") UUID taskId) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validateNotNull((Object)taskId);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labeldetail/task");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(UUID.class, (Object)taskId, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelData.wrap((QueryResult<LabelDetail>)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

