/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.advanced.doc;

import at.mrdevelopment.esl.custom.jersey.doc.ExampleFactory;
import at.mrdevelopment.esl.custom.jersey.doc.Parameter;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JerseyDocGenerator {
    static ESLLogger logger = ESLLogger.getLogger(JerseyDocGenerator.class);
    private final XMLToolkit xmlToolkit;
    private final String sourceDirectory;
    private final String targetDirectory;
    private final ExampleFactory exampleFactory = new ExampleFactory();
    private final Transformer transformer;
    private final RootDoc rootDoc;
    private final Set<Class<?>> resourceClasses;
    private final Set<Class<?>> typeClasses;

    public JerseyDocGenerator(String sourceDirectory, String targetDirectory, RootDoc rootDoc, Class<?>[] resourceClasses, Class<?>[] typeClasses) throws Exception {
        this.xmlToolkit = new XMLToolkit();
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.transformer = this.createTransformer(new StreamSource(new File(sourceDirectory, "reference.xsl")));
        this.rootDoc = rootDoc;
        this.resourceClasses = new HashSet(Arrays.asList(resourceClasses));
        this.typeClasses = new HashSet(Arrays.asList(typeClasses));
        new File(targetDirectory).delete();
        new File(targetDirectory, "generated").mkdirs();
        new File(targetDirectory, "resources").mkdirs();
        new File(targetDirectory, "types").mkdirs();
        new File(targetDirectory, "examples").mkdirs();
        new File(targetDirectory, "xsd").mkdirs();
        this.copyCascadingStylesheetsToTarget();
        this.copyImagesToTarget();
        this.transformIndex();
        this.writeResourcesDocuments();
        this.writeTypesDocuments();
        this.writeResourcesIndex();
        this.writeTypesIndex();
    }

    private void copyCascadingStylesheetsToTarget() throws IOException {
        FileUtils.copyFile((File)new File(this.sourceDirectory, "default.css"), (File)new File(this.targetDirectory, "default.css"));
    }

    private void copyImagesToTarget() throws IOException {
        File imagesSourceDirectory = new File(this.sourceDirectory, "images");
        File imagesTargetDirectory = new File(this.targetDirectory, "images");
        for (File sourceFile : imagesSourceDirectory.listFiles()) {
            if (sourceFile.isDirectory()) continue;
            FileUtils.copyFile((File)sourceFile, (File)new File(imagesTargetDirectory, sourceFile.getName()));
        }
    }

    private void transformIndex() throws IOException {
        this.transformFile(new File(this.sourceDirectory, "index.xml"), new File(this.targetDirectory, "index.html"));
    }

    private void writeResourcesDocuments() throws IOException {
        for (Class<?> resourceClass : this.resourceClasses) {
            Document document = this.xmlToolkit.newDocument();
            Element root = document.createElement("resource");
            root.setAttribute("resourceClass", resourceClass.getSimpleName());
            Element descriptionElement = document.createElement("description");
            ClassDoc classDoc = this.rootDoc.classNamed(resourceClass.getName());
            descriptionElement.setTextContent(classDoc.commentText());
            root.appendChild(descriptionElement);
            document.appendChild(root);
            ArrayList methods = Lists.newArrayList((Object[])resourceClass.getMethods());
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method left, Method right) {
                    return left.getName().compareTo(right.getName());
                }
            });
            for (Method method : methods) {
                if (!this.isWebserviceMethod(method)) continue;
                Element element = this.generateDocForMethod(resourceClass, method, document);
                root.appendChild(element);
            }
            File file = new File(this.targetDirectory, String.format("resources/%s.html", resourceClass.getSimpleName()));
            this.writeDocument(document, file);
        }
    }

    private void writeTypesDocuments() throws Exception {
        for (Class<?> type : this.typeClasses) {
            ClassDoc classDoc = this.rootDoc.classNamed(type.getName());
            logger.info(classDoc.name());
            Document document = this.xmlToolkit.newDocument();
            Element root = document.createElement("type");
            root.setAttribute("name", type.getSimpleName());
            document.appendChild(root);
            if (!classDoc.commentText().isEmpty()) {
                Element descriptionElement = document.createElement("description");
                descriptionElement.setTextContent(classDoc.commentText());
                root.appendChild(descriptionElement);
            }
            Element referenceElement = document.createElement("reference");
            root.appendChild(referenceElement);
            for (SeeTag seeTag : classDoc.seeTags()) {
                Element linkElement = document.createElement("link");
                referenceElement.appendChild(linkElement);
                if (seeTag.referencedClass() != null) {
                    linkElement.setAttribute("type", seeTag.referencedClass().name());
                    continue;
                }
                linkElement.setTextContent(seeTag.text());
            }
            if (type.isPrimitive()) {
                root.setAttribute("type", "primitive");
            } else if (type.getAnnotation(XmlRootElement.class) != null) {
                boolean bl = this.hasMethod(type, "fromString", String.class);
                root.setAttribute("type", bl ? "jaxb-simple" : "jaxb");
                this.writeSchemaFile(type);
                Object jaxbExample = this.exampleFactory.getExample(type);
                if (jaxbExample != null) {
                    this.writeExampleFile(jaxbExample);
                    this.writeJsonExampleFile(jaxbExample);
                }
                root.setAttribute("example", Boolean.toString(jaxbExample != null));
            } else if (type.isEnum()) {
                root.setAttribute("type", "enum");
                this.writeSchemaFile(type);
                for (Object enumValue : type.getEnumConstants()) {
                    Element enumElement = document.createElement("enum");
                    enumElement.setTextContent(enumValue.toString());
                    try {
                        Method method = type.getMethod("getDescription", new Class[0]);
                        enumElement.setAttribute("description", (String)method.invoke(enumValue, new Object[0]));
                    }
                    catch (NoSuchMethodException ignore) {
                        logger.warn("Missing getDescription on type %s", new Object[]{type});
                    }
                    root.appendChild(enumElement);
                }
            } else {
                root.setAttribute("type", "basic");
            }
            File file = new File(this.targetDirectory, String.format("types/%s.html", type.getSimpleName()));
            this.writeDocument(document, file);
        }
    }

    private void writeResourcesIndex() throws IOException {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("resources");
        document.appendChild(root);
        for (Class<?> resourceClass : this.resourceClasses) {
            Element element = document.createElement("resourceClass");
            element.setTextContent(resourceClass.getSimpleName());
            root.appendChild(element);
        }
        File file = new File(this.targetDirectory, "resources/index.html");
        this.writeDocument(document, file);
    }

    private void writeTypesIndex() throws IOException {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("types");
        document.appendChild(root);
        for (Class<?> type : this.typeClasses) {
            Element element = document.createElement("type");
            element.setTextContent(type.getSimpleName());
            root.appendChild(element);
        }
        File file = new File(this.targetDirectory, "types/index.html");
        this.writeDocument(document, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(Document document, File file) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            XMLContentProducer contentProducer = new XMLContentProducer(document, this.transformer, null);
            contentProducer.writeTo((OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformFile(File sourceFile, File targetFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            StreamSource source = new StreamSource(sourceFile);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(source, result);
            }
        }
        catch (TransformerException exc) {
            try {
                throw new IOException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSchemaFile(Class<?> type) throws JAXBException, IOException {
        final File file = new File(new File(this.targetDirectory, "xsd"), type.getSimpleName() + ".xsd");
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            final StreamResult streamResult = new StreamResult(outputStream);
            SchemaOutputResolver sor = new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    streamResult.setSystemId(file);
                    return streamResult;
                }
            };
            jaxbContext.generateSchema(sor);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    private void writeExampleFile(Object jaxbExample) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbExample.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(jaxbExample, new File(new File(this.targetDirectory, "examples"), jaxbExample.getClass().getSimpleName() + ".xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJsonExampleFile(Object jaxbExample) throws JAXBException, IOException {
        JSONJAXBContext jaxbContext = new JSONJAXBContext(new Class[]{jaxbExample.getClass()});
        JSONMarshaller marshaller = jaxbContext.createJSONMarshaller();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(new File(this.targetDirectory, "examples"), jaxbExample.getClass().getSimpleName() + ".json"));
            marshaller.marshallToJSON(jaxbExample, (Writer)writer);
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close((Writer)writer);
    }

    private boolean isWebserviceMethod(Method method) {
        return method.isAnnotationPresent(GET.class) || method.isAnnotationPresent(POST.class) || method.isAnnotationPresent(PUT.class) || method.isAnnotationPresent(DELETE.class) || method.isAnnotationPresent(HEAD.class);
    }

    private Element generateDocForMethod(Class<?> resourceClass, Method method, Document document) {
        Element element = document.createElement("method");
        boolean typeReference = this.typeClasses.contains(method.getReturnType());
        if (!typeReference && !this.isPrimitivOrBasicType(method.getReturnType())) {
            logger.warn("Missing type %s referenced by %s.%s", new Object[]{method.getReturnType().getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName()});
        }
        String response = method.getReturnType().getSimpleName();
        if (method.getAnnotation(Produces.class) != null) {
            response = "Content-type: " + method.getAnnotation(Produces.class).value()[0];
        }
        element.setAttribute("name", method.getName());
        element.setAttribute("method", this.getRequestMethod(method));
        element.setAttribute("url", this.getUrl(resourceClass, method));
        element.setAttribute("response", response);
        element.setAttribute("ref", Boolean.toString(typeReference));
        MethodDoc methodDoc = this.getMethodDoc(method);
        Element referenceElement = document.createElement("reference");
        element.appendChild(referenceElement);
        for (SeeTag seeTag : methodDoc.seeTags()) {
            Element linkElement = document.createElement("link");
            referenceElement.appendChild(linkElement);
            if (seeTag.referencedClass() != null) {
                linkElement.setAttribute("type", seeTag.referencedClass().name());
                continue;
            }
            linkElement.setTextContent(seeTag.text());
        }
        if (!methodDoc.commentText().isEmpty()) {
            Element descriptionElement = document.createElement("description");
            descriptionElement.setTextContent(methodDoc.commentText());
            element.appendChild(descriptionElement);
        }
        for (Parameter parameter : this.getParameters(method, methodDoc)) {
            Element parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("style", parameter.getStyle().toString());
            parameterElement.setAttribute("name", parameter.getName());
            parameterElement.setAttribute("type", parameter.getType().getSimpleName());
            parameterElement.setAttribute("required", Boolean.toString(parameter.isRequired()));
            parameterElement.setAttribute("ref", Boolean.toString(parameter.hasTypeReference()));
            parameterElement.setTextContent(parameter.getComment());
            element.appendChild(parameterElement);
        }
        return element;
    }

    private MethodDoc getMethodDoc(Method method) {
        ClassDoc classDoc = this.rootDoc.classNamed(method.getDeclaringClass().getName());
        for (MethodDoc methodDoc : classDoc.methods()) {
            if (!methodDoc.name().equals(method.getName())) continue;
            return methodDoc;
        }
        return null;
    }

    private boolean isPrimitivOrBasicType(Class<?> type) {
        return type.isPrimitive() || type.getName().startsWith("java") || type.getName().startsWith("org.w3c.dom");
    }

    private boolean isRequired(Class<?> type) {
        return type.isPrimitive() || type.getName().startsWith("at.mrdevelopment");
    }

    private String getRequestMethod(Method method) {
        if (method.isAnnotationPresent(GET.class)) {
            return "GET";
        }
        if (method.isAnnotationPresent(POST.class)) {
            return "POST";
        }
        if (method.isAnnotationPresent(PUT.class)) {
            return "PUT";
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            return "DELETE";
        }
        if (method.isAnnotationPresent(HEAD.class)) {
            return "HEAD";
        }
        throw new AssertionError();
    }

    private String getUrl(Class<?> resourceClass, Method method) {
        Path classPath = resourceClass.getAnnotation(Path.class);
        Path methodPath = method.getAnnotation(Path.class);
        if (classPath == null) {
            return methodPath.value();
        }
        if (methodPath == null) {
            return classPath.value();
        }
        return String.format("%s/%s", classPath.value(), methodPath.value());
    }

    private List<Parameter> getParameters(Method method, MethodDoc methodDoc) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int index = 0; index < parameterTypes.length; ++index) {
            String name = null;
            Class<?> type = parameterTypes[index];
            Parameter.ParameterStyle style = Parameter.ParameterStyle.REQUEST;
            boolean required = this.isRequired(type);
            boolean typeReference = this.typeClasses.contains(type);
            String comment = null;
            if (!typeReference && !this.isPrimitivOrBasicType(type)) {
                logger.warn("Missing type %s referenced by %s.%s", new Object[]{type.getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName()});
            }
            if (methodDoc.paramTags().length > 0) {
                comment = methodDoc.paramTags()[index].parameterComment();
            }
            for (Annotation annotation : parameterAnnotations[index]) {
                if (annotation.annotationType() == QueryParam.class) {
                    QueryParam queryParam = (QueryParam)annotation;
                    name = queryParam.value();
                    style = Parameter.ParameterStyle.QUERY;
                    continue;
                }
                if (annotation.annotationType() != PathParam.class) continue;
                PathParam pathParam = (PathParam)annotation;
                name = pathParam.value();
                style = Parameter.ParameterStyle.PATH;
            }
            Parameter parameter = new Parameter(name, type, style, required, typeReference, comment);
            parameters.add(parameter);
        }
        return parameters;
    }

    private boolean hasMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            type.getMethod("fromString", parameterTypes);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
    }

    private Transformer createTransformer(Source xsltSource) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException exc) {
            throw new RuntimeException(exc);
        }
    }
}

