/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level3.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.level3.ArticleUtils;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.custom.level3.Level3Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.ArticleRecord;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLArticle;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.list.ESLArticlePagedResult;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/articlestore")
@Produces(value={"application/xml", "application/json"})
public class ArticleStoreResource {
    @Context
    private Level2Interface level2Interface;
    @Context
    private Level3Interface level3Interface;

    @GET
    public ESLArticlePagedResult getArticles(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.level3Interface.getQuery("articlerecord/index");
            QueryResult queryResult = this.level3Interface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLArticle.wrap(ArticleUtils.toArticles((QueryResult<ArticleRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction storeArticle(ESLArticle article) {
        JerseyValidationUtils.validateNotNull((Object)article);
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.level3Interface.storeArticle(article.toArticle(), 0L));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{articleNumber}")
    public ESLArticle queryArticleByArticleNumber(@PathParam(value="articleNumber") String articleNumber) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        try {
            return ESLArticle.fromArticle((Article)this.level2Interface.queryArticle(ArticleNumber.fromString((String)articleNumber)));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{articleNumber}")
    public void deleteArticle(@PathParam(value="articleNumber") String articleNumber) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        try {
            this.level3Interface.deleteArticle(ArticleNumber.fromString((String)articleNumber));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

