/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level2.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.level2.MatchingUtils;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.flashing.BasicLED;
import at.mrdevelopment.esl.flashing.LEDColor;
import at.mrdevelopment.esl.flashing.LEDPattern;
import at.mrdevelopment.esl.flashing.LabelLED;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.MatchingRecord;
import at.mrdevelopment.esl.tasks.FlashingTask;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLMatching;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingList;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingPagedResult;
import at.mrdevelopment.esl.type.wrapper.type.ESLBasicLED;
import at.mrdevelopment.esl.type.wrapper.type.ESLFlash;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.sun.jersey.api.NotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/matching")
@Produces(value={"application/xml", "application/json"})
public class MatchingResource {
    @Context
    private Level2Interface eslInterface;

    @GET
    public ESLMatchingPagedResult getMatchings(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matchingrecord/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction modifyMatchings(ESLMatchingList matchings) {
        JerseyValidationUtils.validateNotNull((Object)matchings);
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.modifyMatchings((Collection)matchings.toMatchings(), 0L));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{label}")
    public ESLTransaction storeMatching(@PathParam(value="label") String labelId, @QueryParam(value="articleNumber") String articleNumber, @QueryParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validateNotEmpty((String)template);
        try {
            ESLMatching eslMatching = new ESLMatching(labelId, articleNumber, template);
            Matching matching = eslMatching.toMatching();
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.modifyMatchings(Collections.singletonList(matching), 0L));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{label}")
    public ESLTransaction deleteMatching(@PathParam(value="label") String labelId) throws Exception {
        Matching matching = Matching.newEmptyMatching((LabelId)LabelId.fromString((String)labelId));
        return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.modifyMatchings(Collections.singletonList(matching), 0L));
    }

    @GET
    @Path(value="{label}")
    public ESLMatching getMatchingForLabel(@PathParam(value="label") String labelId) {
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/label");
            List records = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(LabelId.class, (Object)LabelId.fromString((String)labelId))).getRecords();
            if (records.size() != 1) {
                throw new NotFoundException();
            }
            MatchingRecord result = (MatchingRecord)records.get(0);
            return ESLMatching.wrap((Matching)result.toMatching());
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="article/{articleNumber}")
    public ESLMatchingPagedResult getMatchingsForArticle(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) throws DatasetException, SerializeException, MappingException {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/article");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(ArticleNumber.class, (Object)ArticleNumber.fromString((String)articleNumber), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="gtin/{gtin}")
    public ESLMatchingPagedResult getMatchingsForGtin(@PathParam(value="gtin") String gtin, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validateNotEmpty((String)gtin);
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/gtin");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(Gtin.class, (Object)Gtin.fromString((String)gtin), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="template/{template}")
    public ESLMatchingPagedResult getMatchingsForTemplate(@PathParam(value="template") String template, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validateNotEmpty((String)template);
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/template");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(String.class, (Object)template, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unlicenced")
    public ESLMatchingPagedResult getMatchingsForUnlicencedLabels(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/unlicenced");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unregistered")
    public ESLMatchingPagedResult getMatchingsForUnregisteredLabels(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/unregistered");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="missing/article")
    public ESLMatchingPagedResult getMatchingsWithMissingArticle(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/missing/article");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="missing/template")
    public ESLMatchingPagedResult getMatchingsWithMissingTemplate(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/missing/template");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLMatching.wrap(MatchingUtils.toMatchings((QueryResult<MatchingRecord>)queryResult));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{articleNumber}/flash")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction flashMatchedLabels(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="externalId") Long externalId, ESLFlash flash) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validateNotNull((Object)flash);
        try {
            DatasetQuery query = this.eslInterface.getQuery("matching/article");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(ArticleNumber.class, (Object)ArticleNumber.fromString((String)articleNumber)));
            List matchings = queryResult.getRecords();
            ArrayList<FlashingTask> flashingTasks = new ArrayList<FlashingTask>();
            if (!(flash.flash instanceof ESLBasicLED)) {
                JerseyValidationUtils.respondErrorMessage((String)"Unsupported LED type", (Response.Status)Response.Status.BAD_REQUEST);
            }
            ESLBasicLED basicLed = (ESLBasicLED)flash.flash;
            JerseyValidationUtils.validateNotNull((Object)basicLed, (String)"Invalid LED specification", (Object[])new Object[0]);
            BasicLED led = new BasicLED(basicLed.color != null ? basicLed.color : LEDColor.DEFAULT_COLOR, basicLed.pattern != null ? basicLed.pattern : LEDPattern.DEFAULT_PATTERN, basicLed.durationInMinutes != null ? basicLed.durationInMinutes : 0, basicLed.repeatCount != null ? basicLed.repeatCount : 0);
            for (MatchingRecord matching : matchings) {
                flashingTasks.add(new FlashingTask(matching.getLabelId(), TaskPriority.DEFAULT, externalId == null ? 0L : externalId, false, (LabelLED)led));
            }
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.getLevel1Interface().addTasks(new TaskOrder(String.format("Flashing labels matched with article %s", articleNumber), externalId == null ? 0L : externalId, flashingTasks)));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

