/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level2.resource;

import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.export.Level2Importer;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.type.wrapper.element.ESLMessage;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingList;
import at.mrdevelopment.toolkit.StreamUtils;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/import/level2")
@Produces(value={"application/xml", "application/json"})
public class Level2ImportResource {
    @Context
    private Level2Interface eslInterface;

    @POST
    @Path(value="matching")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importMatchings(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLMatchingList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level2Importer)this.eslInterface.getDataImporter()).importMatchings(clear, list);
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="all")
    @Consumes(value={"multipart/form-data"})
    public void importAll(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, FormDataMultiPart multiPart) {
        JerseyValidationUtils.validateNotNull((Object)multiPart);
        List bodyParts = multiPart.getBodyParts();
        if (bodyParts.size() > 0) {
            BodyPart bodyPart = (BodyPart)bodyParts.iterator().next();
            BodyPartEntity entity = (BodyPartEntity)bodyPart.getEntity();
            if (entity != null) {
                InputStream inputStream = entity.getInputStream();
                try {
                    ((Level2Importer)this.eslInterface.getDataImporter()).parseEntries(clear, inputStream);
                }
                catch (Exception exc) {
                    throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
                finally {
                    StreamUtils.close((InputStream)inputStream);
                }
            } else {
                JerseyValidationUtils.respondErrorMessage((String)"Multipart entity not found", (Response.Status)Response.Status.BAD_REQUEST);
            }
        } else {
            JerseyValidationUtils.respondErrorMessage((String)"Form multipart entity not found", (Response.Status)Response.Status.BAD_REQUEST);
        }
    }
}

