/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level2.resource;

import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.export.Level2Exporter;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingList;
import at.mrdevelopment.toolkit.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;

@Path(value="/service/export/level2")
@Produces(value={"application/xml", "application/json"})
public class Level2ExportResource {
    @Context
    private Level2Interface eslInterface;

    @GET
    @Path(value="matching")
    public ESLMatchingList exportMatchings() {
        try {
            return ((Level2Exporter)this.eslInterface.getDataExporter()).exportMatchings();
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="all")
    @Produces(value={"application/octet-stream"})
    public Response exportAll() {
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((Level2Exporter)this.eslInterface.getDataExporter()).exportData((OutputStream)outputStream);
            Response response = Response.ok((Object)new StreamingOutput(){

                public void write(OutputStream paramOutputStream) throws IOException, WebApplicationException {
                    IOUtils.write((byte[])outputStream.toByteArray(), (OutputStream)paramOutputStream);
                }
            }).header("content-disposition", (Object)"attachment; filename = export.zip").build();
            return response;
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            StreamUtils.close((OutputStream)outputStream);
        }
    }
}

