/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level2.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.tasks.ImageRenderingTask;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.element.ESLArticle;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.element.ESLUpdatedArticle;
import at.mrdevelopment.esl.type.wrapper.list.ESLTransactionList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUpdatedArticleList;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;

@Path(value="/service/article")
@Produces(value={"application/xml", "application/json"})
public class ArticleResource {
    @Context
    private Level2Interface eslInterface;
    @Context
    private UpdateImageFactory updateImageFactory;
    @Context
    private ArticleXMLSerializer articleSerializer;

    @GET
    @Path(value="{articleNumber}")
    public ESLArticle queryArticleByArticleNumber(@PathParam(value="articleNumber") String articleNumber) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        try {
            return ESLArticle.fromArticle((Article)this.eslInterface.queryArticle(ArticleNumber.fromString((String)articleNumber)));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="gtin/{gtin}")
    public ESLArticle queryArticleByGtin(@PathParam(value="gtin") String gtin) {
        JerseyValidationUtils.validateNotEmpty((String)gtin);
        try {
            return ESLArticle.fromArticle((Article)this.eslInterface.queryArticle(Gtin.fromString((String)gtin)));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="notify")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransactionList notifyArticlesUpdated(ESLUpdatedArticleList updatedArticles) {
        JerseyValidationUtils.validateNotNull((Object)updatedArticles);
        try {
            ArrayList<TaskTransaction> transactions = new ArrayList<TaskTransaction>(updatedArticles.List.size());
            for (ESLUpdatedArticle updatedArticle : updatedArticles.List) {
                ArticleNumber articleNumber = ArticleNumber.fromString((String)updatedArticle.articleNumber);
                long externalId = updatedArticle.externalId != null ? updatedArticle.externalId : 0L;
                transactions.add(this.eslInterface.articleUpdated(articleNumber, externalId));
            }
            return ESLTransactionList.fromTransactions(transactions);
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{articleNumber}/notify")
    public ESLTransaction notifyArticleUpdated(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="externalId") Long externalId) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.articleUpdated(ArticleNumber.fromString((String)articleNumber), externalId != null ? externalId : 0L));
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{articleNumber}/preview/source")
    @Produces(value={"application/xml"})
    public Document getRenderingSourceRecord(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="label") String labelId, @QueryParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validateNotEmpty((String)template);
        try {
            TemplateTask templateTask = this.getTemplateTask(LabelId.fromString((String)labelId), ArticleNumber.fromString((String)articleNumber), template);
            return (Document)this.updateImageFactory.buildRecordSource(templateTask).getNode();
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{articleNumber}/preview/document")
    @Produces(value={"application/xml"})
    public Document getRenderingDocument(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="label") String labelId, @QueryParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validateNotEmpty((String)template);
        try {
            TemplateTask templateTask = this.getTemplateTask(LabelId.fromString((String)labelId), ArticleNumber.fromString((String)articleNumber), template);
            return (Document)this.updateImageFactory.buildImageRenderingSource(templateTask).getNode();
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{articleNumber}/preview/image")
    @Produces(value={"image/png"})
    public Response getRenderingImage(@PathParam(value="articleNumber") String articleNumber, @QueryParam(value="label") String labelId, @QueryParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)articleNumber);
        JerseyValidationUtils.validateNotEmpty((String)template);
        try {
            TemplateTask templateTask = this.getTemplateTask(LabelId.fromString((String)labelId), ArticleNumber.fromString((String)articleNumber), template);
            BufferedImage image = this.updateImageFactory.createImageFromTask((ImageRenderingTask)templateTask);
            return Response.ok((Object)image).build();
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private TemplateTask getTemplateTask(LabelId label, ArticleNumber articleNumber, String template) throws Exception {
        Article article = this.eslInterface.queryArticle(articleNumber);
        File workingDirectory = new File(Config.getTemplatePath());
        Document articleDocument = this.articleSerializer.toXML(article);
        FileTemplateSource templateSource = new FileTemplateSource(workingDirectory, template);
        return new TemplateXMLTask(label, TaskPriority.NORMAL, 0L, false, (TemplateSource)templateSource, articleDocument, Page.PAGE_0, false);
    }
}

