/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.AbortTaskRequest;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLUpdateStatus;
import at.mrdevelopment.esl.type.wrapper.list.ESLUpdateStatusPagedResult;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.sun.jersey.api.NotFoundException;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/updatestatus")
@Produces(value={"application/xml", "application/json"})
public class UpdateStatusResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLUpdateStatusPagedResult getAllUpdates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/all");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{taskId}")
    public ESLUpdateStatus getUpdateDetail(@PathParam(value="taskId") UUID taskId) {
        JerseyValidationUtils.validateNotNull((Object)taskId);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/task");
            List records = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(UUID.class, (Object)taskId)).getRecords();
            if (records.size() != 1) {
                throw new NotFoundException();
            }
            UpdateStatus result = (UpdateStatus)records.get(0);
            return ESLUpdateStatus.wrap((UpdateStatus)result);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{taskId}/image")
    @Produces(value={"image/png"})
    public Response getImageForTask(@PathParam(value="taskId") UUID taskId) {
        JerseyValidationUtils.validateNotNull((Object)taskId);
        try {
            BufferedImage image = this.eslInterface.getImageForTask(taskId, false);
            if (image == null) {
                JerseyValidationUtils.respondErrorMessage((String)String.format("Image for task with ID %s not found", taskId), (Response.Status)Response.Status.BAD_REQUEST);
            }
            return Response.ok((Object)image).build();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{taskId}")
    public void abortTask(@PathParam(value="taskId") UUID taskId) {
        JerseyValidationUtils.validateNotNull((Object)taskId);
        AbortTaskRequest abortRequest = new AbortTaskRequest(taskId);
        this.eslInterface.abort(Collections.singleton(abortRequest));
    }

    @GET
    @Path(value="waiting")
    public ESLUpdateStatusPagedResult getWaitingUpdates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/waiting");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unsuccessful")
    public ESLUpdateStatusPagedResult getUnsuccessfulUpdates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/unsuccessful");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="transaction/{transactionId}")
    public ESLUpdateStatusPagedResult getUpdatesForTransaction(@PathParam(value="transactionId") long transactionId, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/transaction");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(Long.class, (Object)transactionId, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="label/{label}")
    public ESLUpdateStatusPagedResult getUpdatesForLabel(@PathParam(value="label") String labelId, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/label");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LabelId.class, (Object)LabelId.fromString((String)labelId), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="externalid/{externalId}")
    public ESLUpdateStatusPagedResult getUpdatesForExternalId(@PathParam(value="externalId") long externalId, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/externalid");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(Long.class, (Object)externalId, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{taskId}/history")
    public ESLUpdateStatusPagedResult getUpdateHistoryForTask(@PathParam(value="taskId") UUID taskId, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("updatestatus/taskhistory");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(UUID.class, (Object)taskId, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLUpdateStatus.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

