/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.TransactionStatusInfo;
import at.mrdevelopment.esl.tasks.AbortTransactionRequest;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransactionStatusInfo;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/transaction")
@Produces(value={"application/xml", "application/json"})
public class TransactionResource {
    @Context
    private Level1Interface eslInterface;

    @DELETE
    @Path(value="{transactionId}")
    public void abortTransaction(@PathParam(value="transactionId") long transactionId) {
        if (transactionId > 0L) {
            AbortTransactionRequest abortRequest = new AbortTransactionRequest(transactionId);
            this.eslInterface.abort(Collections.singleton(abortRequest));
        }
    }

    @GET
    @Path(value="{transactionId}/status")
    public ESLTransactionStatusInfo getTransactionStatus(@PathParam(value="transactionId") long transactionId) {
        try {
            if (transactionId == 0L) {
                return ESLTransactionStatusInfo.wrap((TransactionStatusInfo)TransactionStatusInfo.createEmptyTransactionInfo());
            }
            DatasetQuery query = this.eslInterface.getQuery("transaction/status");
            List results = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(Long.class, (Object)transactionId)).getRecords();
            if (results.size() == 0) {
                JerseyValidationUtils.respondErrorMessage((String)String.format("No transaction with ID %d found", transactionId), (Response.Status)Response.Status.BAD_REQUEST);
            }
            TransactionStatusInfo result = (TransactionStatusInfo)results.get(0);
            return ESLTransactionStatusInfo.wrap((TransactionStatusInfo)result);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

