/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLTemplate;
import at.mrdevelopment.esl.type.wrapper.list.ESLTemplatePagedResult;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/service/template")
@Produces(value={"application/xml", "application/json"})
public class TemplateResource {
    private final XMLContentProducerFactory factory = XMLContentProducerFactory.newInstance();
    private XMLToolkit xmlToolkit;
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLTemplatePagedResult getTemplates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("template/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLTemplate.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="invalid")
    public ESLTemplatePagedResult getInvalidTemplates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("template/invalid");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLTemplate.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{template}")
    public Document getTemplate(@PathParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)template);
        try {
            if (this.xmlToolkit == null) {
                this.xmlToolkit = new XMLToolkit();
            }
            Element documentElement = this.xmlToolkit.getDocumentRootFromFile(this.getTemplateFile(template));
            return documentElement.getOwnerDocument();
        }
        catch (InitializationException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (FileNotFoundException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="{template}")
    @Consumes(value={"application/xml"})
    public void storeTemplate(@PathParam(value="template") String template, Document document) {
        JerseyValidationUtils.validateNotEmpty((String)template);
        JerseyValidationUtils.validateNotNull((Object)document);
        File templateFile = this.getTemplateFile(template);
        FileOutputStream stream = null;
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        FileLock lock = null;
        try {
            stream = new FileOutputStream(templateFile);
            channel = stream.getChannel();
            lock = channel.tryLock();
            if (lock != null) {
                this.factory.createContentProducer(document).writeTo((OutputStream)stream);
            }
        }
        catch (IOException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException exc) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException exc) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException exc) {}
            }
            StreamUtils.close((OutputStream)stream);
        }
    }

    @DELETE
    @Path(value="{template}")
    public Response removeTemplate(@PathParam(value="template") String template) {
        JerseyValidationUtils.validateNotEmpty((String)template);
        File templateFile = this.getTemplateFile(template);
        if (templateFile.exists()) {
            FileUtils.deleteQuietly((File)templateFile);
            if (templateFile.exists()) {
                return Response.serverError().entity((Object)"Could not delete template").build();
            }
        }
        return Response.ok().build();
    }

    private File getTemplateFile(String template) {
        String templateName = FilenameUtils.isExtension((String)template, (String)"xsl") ? template : template + ".xsl";
        return new File(Config.getTemplatePath(), new File(templateName).getName());
    }
}

