/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.firmware.FileFirmwareSource;
import at.mrdevelopment.esl.firmware.FirmwareSource;
import at.mrdevelopment.esl.flashing.BasicLED;
import at.mrdevelopment.esl.flashing.LEDColor;
import at.mrdevelopment.esl.flashing.LEDPattern;
import at.mrdevelopment.esl.flashing.LabelLED;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.tasks.FirmwareTask;
import at.mrdevelopment.esl.tasks.FlashingTask;
import at.mrdevelopment.esl.tasks.ImageRenderingTask;
import at.mrdevelopment.esl.tasks.NDEFMessageTask;
import at.mrdevelopment.esl.tasks.PingTask;
import at.mrdevelopment.esl.tasks.RebootTask;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.tasks.ResetTask;
import at.mrdevelopment.esl.tasks.SwitchPageTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.task.ESLFirmwareTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLFlashingTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLImageTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLNDEFTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLPingTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLRebootTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLRefreshTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLResetTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLSwitchPageTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLTask;
import at.mrdevelopment.esl.type.wrapper.task.ESLTaskOrder;
import at.mrdevelopment.esl.type.wrapper.task.ESLTemplateTask;
import at.mrdevelopment.esl.type.wrapper.type.ESLBasicLED;
import at.mrdevelopment.esl.type.wrapper.type.ESLNDEFMessage;
import at.mrdevelopment.esl.type.wrapper.type.ESLNDEFMessageType;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Path(value="/service/task")
@Produces(value={"application/xml", "application/json"})
public class TaskResource {
    @Context
    private Level1Interface eslInterface;
    @Context
    private UpdateImageFactory updateImageFactory;
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction scheduleTasks(ESLTaskOrder order) {
        JerseyValidationUtils.validateNotNull((Object)order);
        JerseyValidationUtils.validateNotEmpty((ESLTaskOrder)order);
        try {
            ArrayList<Task> tasks = new ArrayList<Task>(order.Task.size());
            for (ESLTask task : order.Task) {
                Task targetTask = this.toTask(task);
                tasks.add(targetTask);
            }
            String transactionTitle = order.Title;
            long externalId = order.ExternalId != null ? order.ExternalId : 0L;
            TaskOrder taskOrder = new TaskOrder(transactionTitle, externalId, tasks);
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(taskOrder));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Task toTask(ESLTask task) throws SerializeException {
        LabelId labelId = LabelId.fromString((String)task.LabelId);
        TaskPriority priority = task.TaskPriority != null ? task.TaskPriority : TaskPriority.NORMAL;
        long externalId = task.ExternalId != null ? task.ExternalId : 0L;
        boolean replaceWaitingTasks = task.ReplaceWaitingTasks != null ? task.ReplaceWaitingTasks : false;
        Integer retryValidInMinutes = task.RetryValidInMinutes;
        if (task instanceof ESLImageTask) {
            ESLImageTask imageTask = (ESLImageTask)task;
            BufferedImage image = (BufferedImage)imageTask.Image;
            JerseyValidationUtils.validateNotNull((Object)image, (String)"No image found", (Object[])new Object[0]);
            Page page = imageTask.Page != null ? Page.valueOf((int)imageTask.Page) : Page.DEFAULT;
            boolean preload = imageTask.Preload != null ? imageTask.Preload : false;
            boolean skipOnEqualImage = imageTask.SkipOnEqualImage != null ? imageTask.SkipOnEqualImage : false;
            return new BinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, image, page, preload, skipOnEqualImage, retryValidInMinutes);
        }
        if (task instanceof ESLRefreshTask) {
            return new RefreshDisplayTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        }
        if (task instanceof ESLResetTask) {
            return new ResetTask(labelId, priority, externalId, replaceWaitingTasks, task.RetryValidInMinutes);
        }
        if (task instanceof ESLSwitchPageTask) {
            ESLSwitchPageTask switchPageTask = (ESLSwitchPageTask)task;
            JerseyValidationUtils.validateNotNull((Object)switchPageTask.Page, (String)"No page found", (Object[])new Object[0]);
            Page page = Page.valueOf((int)switchPageTask.Page);
            int duration = switchPageTask.DurationInMinutes != null ? switchPageTask.DurationInMinutes : 0;
            return new SwitchPageTask(labelId, priority, externalId, replaceWaitingTasks, page, duration, retryValidInMinutes);
        }
        if (task instanceof ESLTemplateTask) {
            ESLTemplateTask templateTask = (ESLTemplateTask)task;
            Page page = templateTask.Page != null ? Page.valueOf((int)templateTask.Page) : Page.DEFAULT;
            boolean preload = templateTask.Preload != null ? templateTask.Preload : false;
            boolean skipOnEqualImage = templateTask.SkipOnEqualImage != null ? templateTask.SkipOnEqualImage : false;
            JerseyValidationUtils.validateNotNull((Object)templateTask.content, (String)"No record content found", (Object[])new Object[0]);
            Document document = this.xmlToolkit.newDocument();
            Node contentNode = document.importNode(templateTask.content, true);
            document.appendChild(contentNode);
            File workingDirectory = new File(Config.getTemplatePath());
            JerseyValidationUtils.validateNotNull((Object)templateTask.template, (String)"No template specified", (Object[])new Object[0]);
            FileTemplateSource templateSource = new FileTemplateSource(workingDirectory, templateTask.template);
            return new TemplateXMLTask(labelId, priority, externalId, replaceWaitingTasks, (TemplateSource)templateSource, document, page, preload, skipOnEqualImage, retryValidInMinutes);
        }
        if (task instanceof ESLPingTask) {
            return new PingTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        }
        if (task instanceof ESLFlashingTask) {
            ESLFlashingTask flashingTask = (ESLFlashingTask)task;
            ESLBasicLED basicLed = flashingTask.basicLed;
            JerseyValidationUtils.validateNotNull((Object)flashingTask.basicLed, (String)"Invalid LED specification", (Object[])new Object[0]);
            BasicLED led = new BasicLED(basicLed.color != null ? basicLed.color : LEDColor.DEFAULT_COLOR, basicLed.pattern != null ? basicLed.pattern : LEDPattern.DEFAULT_PATTERN, basicLed.durationInMinutes != null ? basicLed.durationInMinutes : 0, basicLed.repeatCount != null ? basicLed.repeatCount : 0);
            return new FlashingTask(labelId, priority, externalId, replaceWaitingTasks, (LabelLED)led, retryValidInMinutes);
        }
        if (task instanceof ESLRebootTask) {
            return new RebootTask(labelId, priority, externalId, replaceWaitingTasks, retryValidInMinutes);
        }
        if (task instanceof ESLFirmwareTask) {
            ESLFirmwareTask firmwareTask = (ESLFirmwareTask)task;
            FileFirmwareSource firmwareSource = new FileFirmwareSource(new File(Config.getFirmwarePath(), firmwareTask.Firmware).getPath());
            return new FirmwareTask(labelId, priority, externalId, replaceWaitingTasks, (FirmwareSource)firmwareSource, retryValidInMinutes);
        }
        if (task instanceof ESLNDEFTask) {
            ESLNDEFTask ndefTask = (ESLNDEFTask)task;
            ESLNDEFMessage message = ndefTask.Message;
            if (message.type == ESLNDEFMessageType.URL) {
                try {
                    return new NDEFMessageTask(labelId, priority, externalId, replaceWaitingTasks, message.value, retryValidInMinutes);
                }
                catch (MalformedURLException exc) {
                    throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
        }
        throw new SerializeException("Invalid task type", new Object[0]);
    }

    @POST
    @Path(value="preview/source")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml"})
    public Document getRenderingSourceRecord(ESLTemplateTask templateTask) {
        JerseyValidationUtils.validateNotNull((Object)templateTask);
        try {
            TemplateTask task = (TemplateTask)this.toTask((ESLTask)templateTask);
            return (Document)this.updateImageFactory.buildRecordSource(task).getNode();
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ImageRenderingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="preview/document")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml"})
    public Document getRenderingDocument(ESLTemplateTask templateTask) {
        JerseyValidationUtils.validateNotNull((Object)templateTask);
        try {
            TemplateTask task = (TemplateTask)this.toTask((ESLTask)templateTask);
            return (Document)this.updateImageFactory.buildImageRenderingSource(task).getNode();
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ImageRenderingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="preview/image")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"image/png"})
    public Response getRenderingImage(ESLTemplateTask templateTask) {
        JerseyValidationUtils.validateNotNull((Object)templateTask);
        try {
            TemplateTask task = (TemplateTask)this.toTask((ESLTask)templateTask);
            BufferedImage image = this.updateImageFactory.createImageFromTask((ImageRenderingTask)task);
            return Response.ok((Object)image).build();
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ImageRenderingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (OptionException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (BarcodeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

