/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.tag.LabelTagsUpdate;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLTag;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLTagPagedResult;
import at.mrdevelopment.toolkit.xml.SerializeException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/tag")
@Produces(value={"application/xml", "application/json"})
public class TagResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLTagPagedResult getTags(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("tags");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLTag.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="add")
    @Consumes(value={"application/xml", "application/json"})
    public void addTagsToLabels(ESLLabelList labelList) {
        JerseyValidationUtils.validateNotNull((Object)labelList);
        try {
            this.eslInterface.updateLabelTags(labelList.toLabelTagsUpdate(LabelTagsUpdate.Operation.ADD));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="remove")
    @Consumes(value={"application/xml", "application/json"})
    public void removeTagsFromLabels(ESLLabelList labelList) {
        JerseyValidationUtils.validateNotNull((Object)labelList);
        try {
            this.eslInterface.updateLabelTags(labelList.toLabelTagsUpdate(LabelTagsUpdate.Operation.REMOVE));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

