/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLoggingEntry;
import at.mrdevelopment.esl.type.wrapper.list.ESLLoggingEntryPagedResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/logging")
@Produces(value={"application/xml", "application/json"})
public class LoggingResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    @Path(value="{level}")
    public ESLLoggingEntryPagedResult getTemplates(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="level") String level) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validateNotEmpty((String)level);
        try {
            DatasetQuery query = this.eslInterface.getQuery("logging/level");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LogLevel.class, (Object)LogLevel.valueOf((String)level.toUpperCase()), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLoggingEntry.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

