/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLicense;
import at.mrdevelopment.esl.type.wrapper.list.ESLLicensePagedResult;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/license")
@Produces(value={"application/xml", "application/json"})
public class LicenseResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLLicensePagedResult getLicenses(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("licencerecord/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLicense.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public void storeLicense(ESLLicense license) {
        JerseyValidationUtils.validateNotNull((Object)license);
        try {
            this.eslInterface.addLicense(license.toLicence());
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    public void removeAllLicenses() {
        try {
            this.eslInterface.removeAllLicenses();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

