/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.export.Level1Importer;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.type.wrapper.element.ESLMessage;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLicenseList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUserList;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/import/level1")
@Produces(value={"application/xml", "application/json"})
public class Level1ImportResource {
    @Context
    private Level1Interface eslInterface;

    @POST
    @Path(value="license")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importLicenses(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLLicenseList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level1Importer)this.eslInterface.getDataImporter()).importLicenses(clear, list);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="label")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importLabels(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLLabelList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level1Importer)this.eslInterface.getDataImporter()).importLabels(clear, list);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="accesspoint")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importAccessPoints(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLAccessPointRegistrationList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level1Importer)this.eslInterface.getDataImporter()).importAccessPoints(clear, list);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MalformedURLException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="configuration")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importConfigurationKeys(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLConfigurationList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level1Importer)this.eslInterface.getDataImporter()).importConfigurationKeys(clear, list);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="user")
    @Consumes(value={"application/xml", "application/json"})
    public ESLMessage importUsers(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, ESLUserList list) {
        JerseyValidationUtils.validateNotNull((Object)list);
        try {
            return ((Level1Importer)this.eslInterface.getDataImporter()).importUsers(clear, list);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="all")
    @Consumes(value={"multipart/form-data"})
    public void importAll(@DefaultValue(value="false") @QueryParam(value="clear") boolean clear, FormDataMultiPart multiPart) {
        JerseyValidationUtils.validateNotNull((Object)multiPart);
        List bodyParts = multiPart.getBodyParts();
        if (bodyParts.size() > 0) {
            BodyPart bodyPart = (BodyPart)bodyParts.iterator().next();
            BodyPartEntity entity = (BodyPartEntity)bodyPart.getEntity();
            if (entity != null) {
                InputStream inputStream = entity.getInputStream();
                try {
                    ((Level1Importer)this.eslInterface.getDataImporter()).parseEntries(clear, inputStream);
                }
                catch (Exception exc) {
                    throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
                finally {
                    StreamUtils.close((InputStream)inputStream);
                }
            } else {
                JerseyValidationUtils.respondErrorMessage((String)"Multipart entity not found", (Response.Status)Response.Status.BAD_REQUEST);
            }
        } else {
            JerseyValidationUtils.respondErrorMessage((String)"Form multipart entity not found", (Response.Status)Response.Status.BAD_REQUEST);
        }
    }
}

