/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.export.Level1Exporter;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLicenseList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUserList;
import at.mrdevelopment.toolkit.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;

@Path(value="/service/export/level1")
@Produces(value={"application/xml", "application/json"})
public class Level1ExportResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    @Path(value="license")
    public ESLLicenseList exportLicenses() {
        try {
            return ((Level1Exporter)this.eslInterface.getDataExporter()).exportLicenses();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="label")
    public ESLLabelList exportLabels() {
        try {
            return ((Level1Exporter)this.eslInterface.getDataExporter()).exportLabels();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="accesspoint")
    public ESLAccessPointRegistrationList exportAccessPoints() {
        try {
            return ((Level1Exporter)this.eslInterface.getDataExporter()).exportAccessPoints();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="configuration")
    public ESLConfigurationList exportConfigurationKeys() {
        try {
            return ((Level1Exporter)this.eslInterface.getDataExporter()).exportConfigurationKeys();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="user")
    public ESLUserList exportUsers() {
        try {
            return ((Level1Exporter)this.eslInterface.getDataExporter()).exportUsers();
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="all")
    @Produces(value={"application/octet-stream"})
    public Response exportAll() {
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((Level1Exporter)this.eslInterface.getDataExporter()).exportData((OutputStream)outputStream);
            Response response = Response.ok((Object)new StreamingOutput(){

                public void write(OutputStream paramOutputStream) throws IOException, WebApplicationException {
                    IOUtils.write((byte[])outputStream.toByteArray(), (OutputStream)paramOutputStream);
                }
            }).header("content-disposition", (Object)"attachment; filename = export.zip").build();
            return response;
        }
        catch (Exception exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            StreamUtils.close((OutputStream)outputStream);
        }
    }
}

