/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.security.RegistrationCode;
import at.mrdevelopment.esl.core.security.UnlockCode;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.tasks.UnlockLabelTask;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabel;
import at.mrdevelopment.esl.type.wrapper.element.ESLTransaction;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelList;
import at.mrdevelopment.esl.type.wrapper.list.ESLUnlockCodeList;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/label")
@Produces(value={"application/xml", "application/json"})
public class LabelResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLLabelList getRegisteredLabels() {
        try {
            return (ESLLabelList)ESLWrapper.wrap((Collection)this.eslInterface.getRegisteredLabels(), LabelRegistration.class, ESLLabel.class, ESLLabelList.class);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction registerLabels(ESLLabelList labels) {
        JerseyValidationUtils.validateNotNull((Object)labels);
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.registerLabels((Collection)labels.toLabelRegistrations(), 0L));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="unlock")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction unlockLabels(ESLUnlockCodeList unlockCodes) {
        JerseyValidationUtils.validateNotNull((Object)unlockCodes);
        try {
            ArrayList<UnlockLabelTask> tasks = new ArrayList<UnlockLabelTask>(unlockCodes.List.size());
            for (UnlockCode unlockCode : unlockCodes.toUnlockCodes()) {
                UnlockLabelTask task = new UnlockLabelTask(unlockCode.getLabelId(), unlockCode.getPuk(), TaskPriority.NORMAL, 0L, false);
                tasks.add(task);
            }
            String transactionTitle = String.format("Unlocking %d labels", tasks.size());
            TaskOrder taskOrder = new TaskOrder(transactionTitle, 0L, tasks);
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.addTasks(taskOrder));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="register/{registrationCode}")
    public ESLTransaction registerLabel(@PathParam(value="registrationCode") String registrationCode) {
        JerseyValidationUtils.validateNotNull((Object)registrationCode);
        try {
            RegistrationCode registration = RegistrationCode.fromBase58((String)registrationCode);
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.registerLabels(LabelRegistration.fromRegistrationCodes(Collections.singleton(registration)), 0L));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="unregister")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction unregisterLabels(ESLLabelList labels) {
        JerseyValidationUtils.validateNotNull((Object)labels);
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.unregisterLabels((Collection)labels.toLabelIds(), 0L));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{labelId}")
    public ESLTransaction unregisterLabel(@PathParam(value="labelId") String labelId) {
        try {
            return ESLTransaction.fromTransaction((TaskTransaction)this.eslInterface.unregisterLabels(Collections.singleton(LabelId.fromString((String)labelId)), 0L));
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="replacebattery")
    @Consumes(value={"application/xml", "application/json"})
    public ESLTransaction replaceBatteries(ESLLabelList labels) {
        JerseyValidationUtils.validateNotNull((Object)labels);
        try {
            List labelIds = labels.toLabelIds();
            TaskTransaction taskTransaction = this.eslInterface.batteryReplaced((Collection)labelIds);
            return ESLTransaction.fromTransaction((TaskTransaction)taskTransaction);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

