/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.level1.DateQueryParam;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabelInfo;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabelStatistics;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabelType;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelInfoPagedResult;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelStatisticsList;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelTypeList;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/service/labelinfo")
@Produces(value={"application/xml", "application/json"})
public class LabelInfoResource {
    static ESLLogger logger = ESLLogger.getLogger(LabelInfoResource.class);
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLLabelInfoPagedResult getLabels(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="modifiedafter")
    public ESLLabelInfoPagedResult getLabelsModifiedAfter(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @DefaultValue(value="1970-01-01T00:00:00.000Z") @QueryParam(value="timestamp") DateQueryParam timestamp) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/modifiedafter");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(DateTime.class, (Object)timestamp.getDateTime(), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (IllegalArgumentException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{label}")
    public ESLLabelInfo getLabel(@PathParam(value="label") String labelId) {
        DatasetQuery query = this.eslInterface.getQuery("labelinfo/details");
        try {
            List results = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(LabelId.class, (Object)LabelId.fromString((String)labelId))).getRecords();
            if (results.size() != 1) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("Label with ID %s not found", labelId)).build());
            }
            LabelInfo result = (LabelInfo)results.get(0);
            return ESLLabelInfo.wrap((LabelInfo)result);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="status/{connectionStatus}")
    public ESLLabelInfoPagedResult getLabelsWithConnectionStatus(@PathParam(value="connectionStatus") ConnectionStatus connectionStatus, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validateNotNull((Object)connectionStatus);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/status");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(ConnectionStatus.class, (Object)connectionStatus, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="error")
    public ESLLabelInfoPagedResult getLabelsWithErrors(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/error");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="problem")
    public ESLLabelInfoPagedResult getLabelsWithProblems(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/problem");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unencrypted")
    public ESLLabelInfoPagedResult getLabelsWithoutEncryption(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/noencryption");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="powerstatus/{powerStatus}")
    public ESLLabelInfoPagedResult getLabelsWithPowerStatus(@PathParam(value="powerStatus") PowerStatus powerStatus, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validateNotNull((Object)powerStatus);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/powerstatus");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(PowerStatus.class, (Object)powerStatus, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unsuccessful")
    public ESLLabelInfoPagedResult getLabelsWithUnsuccessfulLastUpdate(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/unsuccessful");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="tag/{tag}")
    public ESLLabelInfoPagedResult getLabelsWithTag(@PathParam(value="tag") String tag, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        JerseyValidationUtils.validateNotNull((Object)tag);
        JerseyValidationUtils.validateNotEmpty((String)tag);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/tag");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(String.class, (Object)tag, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unmatched")
    public ESLLabelInfoPagedResult getLabelsWithoutMatching(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/unmatched");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="notseenforminutes/{minutes}")
    public ESLLabelInfoPagedResult getLabelsNotSeenForMinutes(@PathParam(value="minutes") Integer minutes, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/notseenforminutes");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(Integer.class, (Object)minutes, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="unseen")
    public ESLLabelInfoPagedResult getUnseenLabels(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/unseen");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="seeninlastminutes/{minutes}")
    public ESLLabelInfoPagedResult getLabelsSeenInLastMinutes(@PathParam(value="minutes") Integer minutes, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/seeninlastminutes");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(Integer.class, (Object)minutes, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="updatedafter")
    public ESLLabelInfoPagedResult getLabelsUpdatedAfter(@QueryParam(value="day") Integer day, @QueryParam(value="month") Integer month, @QueryParam(value="year") Integer year, @QueryParam(value="hour") Integer hour, @QueryParam(value="minute") Integer minute, @QueryParam(value="second") Integer second, @QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        second = second == null || second < 0 || second >= 60 ? 0 : second;
        minute = minute == null || minute < 0 || minute >= 60 ? 0 : minute;
        hour = hour == null || hour < 0 || hour >= 24 ? 0 : hour;
        try {
            DateTime dateTime = new DateTime(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute == null ? 0 : minute, second == null ? 0 : second);
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/updatedafter");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(DateTime.class, (Object)dateTime, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfo.wrap((QueryResult)queryResult);
        }
        catch (IllegalArgumentException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="type")
    public ESLLabelTypeList getLabelTypes() {
        return ESLLabelTypeList.allLabelTypes();
    }

    @GET
    @Path(value="type/{label}")
    public ESLLabelType getLabelTypeForLabel(@PathParam(value="label") String labelId) {
        try {
            LabelId label = LabelId.fromString((String)labelId);
            return ESLLabelType.fromLabelId((LabelId)label);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="statistics")
    public ESLLabelStatisticsList getLabelStatistics() {
        try {
            DatasetQuery query = this.eslInterface.getQuery("labelinfo/statistics");
            QueryResult result = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
            List labelStatisticsList = result.getRecords();
            ESLLabelStatisticsList list = (ESLLabelStatisticsList)ESLWrapper.wrap((Collection)labelStatisticsList, LabelStatistics.class, ESLLabelStatistics.class, ESLLabelStatisticsList.class);
            list.totalLabels = ((LabelStatistics)labelStatisticsList.get(0)).getTotalLabels();
            return list;
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

