/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.level1.DateQueryParam;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabelInfoHistory;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelInfoHistoryPagedResult;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/service/labelinfohistory")
@Produces(value={"application/xml", "application/json"})
public class LabelInfoHistoryResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLLabelInfoHistoryPagedResult getLabelInfoHistory(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("history/labelinfo/all");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfoHistory.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{label}")
    public ESLLabelInfoHistoryPagedResult getLabelInfoHistoryForLabel(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") LabelId labelId) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("history/labelinfo/label");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(LabelId.class, (Object)labelId, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfoHistory.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="updatedafter")
    public ESLLabelInfoHistoryPagedResult getLabelInfoHistoryUpdatedAfter(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @DefaultValue(value="1970-01-01T00:00:00.000Z") @QueryParam(value="timestamp") DateQueryParam timestamp) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("history/labelinfo/updatedafter");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newSearchQuery(DateTime.class, (Object)timestamp.getDateTime(), (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLLabelInfoHistory.wrap((QueryResult)queryResult);
        }
        catch (IllegalArgumentException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (DatasetException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exception) {
            throw JerseyValidationUtils.createException((Throwable)exception, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

