/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.jersey.level1.LabelEventStorage;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabelEvent;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelEventPagedResult;
import at.mrdevelopment.toolkit.xml.SerializeException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/labelevent")
@Produces(value={"application/xml", "application/json"})
public class LabelEventResource {
    @Context
    private LabelEventStorage labelEventStorage;

    @GET
    public ESLLabelEventPagedResult getEvents(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        recordsPerPage = recordsPerPage == null ? Config.getRecordsPerPage() : recordsPerPage;
        try {
            return page == null ? ESLLabelEvent.wrap(this.labelEventStorage.getLabelEvents()) : ESLLabelEvent.wrapPaged((int)page, (int)recordsPerPage, (int)this.labelEventStorage.getRecordCount(), this.labelEventStorage.getLabelEvents(page, recordsPerPage));
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{label}")
    public ESLLabelEventPagedResult getEventsForLabel(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage, @PathParam(value="label") String labelId) {
        JerseyValidationUtils.validatePage((Integer)page);
        recordsPerPage = recordsPerPage == null ? Config.getRecordsPerPage() : recordsPerPage;
        try {
            LabelId label = LabelId.fromString((String)labelId);
            return page == null ? ESLLabelEvent.wrap(this.labelEventStorage.getLabelEvents(label)) : ESLLabelEvent.wrapPaged((int)page, (int)recordsPerPage, (int)this.labelEventStorage.getRecordCount(label), this.labelEventStorage.getLabelEvents(page, recordsPerPage, label));
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

