/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLFont;
import at.mrdevelopment.esl.type.wrapper.list.ESLFontPagedResult;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.text.ESLFontLoader;
import at.mrdevelopment.toolkit.text.JavaFontLoader;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Path(value="/service/font")
@Produces(value={"application/xml", "application/json"})
public class FontResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLFontPagedResult getFonts(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("fontrecord/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLFont.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="store")
    @Consumes(value={"text/plain"})
    public void storeFont(String encodedFont) {
        JerseyValidationUtils.validateNotNull((Object)encodedFont);
        ByteArrayInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            byte[] fontData = DatatypeConverter.parseBase64Binary((String)encodedFont);
            inputStream = new ByteArrayInputStream(fontData);
            if (!new ESLFontLoader().isFontValid((InputStream)inputStream)) {
                throw new WebApplicationException(Response.serverError().entity((Object)"Invalid font").build());
            }
            inputStream.reset();
            Font font = new JavaFontLoader().createFont((InputStream)inputStream);
            outputStream = new FileOutputStream(new File(Config.getFontsPath(), font.getName() + ".ttf"));
            IOUtils.write((byte[])fontData, (OutputStream)outputStream);
        }
        catch (Exception exc) {
            try {
                throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
        StreamUtils.close((OutputStream)outputStream);
    }

    @DELETE
    @Path(value="{font}")
    public void removeFont(@PathParam(value="font") String font) {
        File fontFile = this.getFontFile(font);
        if (fontFile.exists()) {
            FileUtils.deleteQuietly((File)fontFile);
            if (fontFile.exists()) {
                throw new WebApplicationException(Response.serverError().entity((Object)"Could not delete font").build());
            }
        }
    }

    private File getFontFile(String font) {
        String fontName = FilenameUtils.isExtension((String)font, (String[])new String[]{"ttf", "TTF", "OTF", "otf"}) ? font : font + ".ttf";
        return new File(Config.getFontsPath(), fontName);
    }
}

