/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLFirmware;
import at.mrdevelopment.esl.type.wrapper.list.ESLFirmwarePagedResult;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

@Path(value="/service/firmware")
@Produces(value={"application/xml", "application/json"})
public class FirmwareResource {
    private final XMLContentProducerFactory factory = XMLContentProducerFactory.newInstance();
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLFirmwarePagedResult getFirmwareFiles(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("firmwarerecord/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLFirmware.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="{firmware}")
    @Consumes(value={"application/xml"})
    public void storeFirmware(@PathParam(value="firmware") String firmware, Document document) {
        JerseyValidationUtils.validateNotEmpty((String)firmware);
        JerseyValidationUtils.validateNotNull((Object)document);
        File firmwareFile = this.getFirmwareFile(firmware, "xml");
        FileOutputStream stream = null;
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        FileLock lock = null;
        try {
            stream = new FileOutputStream(firmwareFile);
            channel = stream.getChannel();
            lock = channel.tryLock();
            if (lock != null) {
                this.factory.createContentProducer(document).writeTo((OutputStream)stream);
            }
        }
        catch (IOException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SerializeException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException exc) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException exc) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException exc) {}
            }
            StreamUtils.close((OutputStream)stream);
        }
    }

    @POST
    @Path(value="{firmware}")
    @Consumes(value={"text/plain"})
    public void storeFont(@PathParam(value="firmware") String firmware, String encodedFirmware) {
        JerseyValidationUtils.validateNotNull((Object)encodedFirmware);
        ByteArrayInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            byte[] firmwareData = DatatypeConverter.parseBase64Binary((String)encodedFirmware);
            inputStream = new ByteArrayInputStream(firmwareData);
            inputStream.reset();
            outputStream = new FileOutputStream(this.getFirmwareFile(firmware, "hex"));
            IOUtils.write((byte[])firmwareData, (OutputStream)outputStream);
        }
        catch (Exception exc) {
            try {
                throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
        StreamUtils.close((OutputStream)outputStream);
    }

    @DELETE
    @Path(value="{firmware}")
    public Response removeFirmware(@PathParam(value="firmware") String firmware) {
        JerseyValidationUtils.validateNotEmpty((String)firmware);
        File firmwareFile = new File(Config.getFirmwarePath(), firmware);
        if (firmwareFile.exists()) {
            FileUtils.deleteQuietly((File)firmwareFile);
            if (firmwareFile.exists()) {
                return Response.serverError().entity((Object)"Could not delete firmware").build();
            }
        }
        return Response.ok().build();
    }

    private File getFirmwareFile(String firmware, String extension) {
        File directory = new File(Config.getFirmwarePath());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return new File(Config.getFirmwarePath(), FilenameUtils.isExtension((String)firmware, (String)extension) ? firmware : firmware + "." + extension);
    }
}

