/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.query.ScrollableQueryResult;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLConfiguration;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationPagedResult;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/configuration")
@Produces(value={"application/xml", "application/json"})
public class ConfigurationResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLConfigurationPagedResult getConfiguration(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        DatasetQuery query = this.eslInterface.getQuery("configuration/index");
        try {
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLConfiguration.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="modified")
    public ESLConfigurationPagedResult getModifiedConfiguration(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        DatasetQuery query = this.eslInterface.getQuery("configuration/index");
        try {
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedQuery());
            List modified = Configuration.filterModified((Iterable)queryResult.getRecords());
            QueryResult pageResults = ScrollableQueryResult.getResultsForPage((List)modified, (Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage());
            return ESLConfiguration.wrap((QueryResult)pageResults);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{key}")
    public ESLConfiguration getConfiguration(@PathParam(value="key") String key) {
        DatasetQuery query = this.eslInterface.getQuery("configuration/key");
        JerseyValidationUtils.validateNotNull((Object)key);
        try {
            Configuration result = this.queryConfiguration((DatasetQuery<Configuration, String>)query, key);
            return ESLConfiguration.wrap((Configuration)result);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.BAD_REQUEST);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{key}")
    public void setConfiguration(@PathParam(value="key") String key, @QueryParam(value="value") String value) {
        JerseyValidationUtils.validateNotNull((Object)key);
        try {
            if (this.getConfiguration(key) == null) {
                JerseyValidationUtils.respondErrorMessage((String)String.format("Configuration key %s not found", key), (Response.Status)Response.Status.NOT_FOUND);
            }
            this.eslInterface.updateConfiguration(key, value);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{key}")
    public void revertConfigurationToDefault(@PathParam(value="key") String key) {
        JerseyValidationUtils.validateNotNull((Object)key);
        DatasetQuery query = this.eslInterface.getQuery("configuration/key");
        try {
            Configuration result = this.queryConfiguration((DatasetQuery<Configuration, String>)query, key);
            this.eslInterface.updateConfiguration(key, result.getDefaultValue());
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Configuration queryConfiguration(DatasetQuery<Configuration, String> query, String key) throws DatasetException {
        List records = this.eslInterface.executeQuery(query, QueryRestriction.newUnpagedSearchQuery(String.class, (Object)key)).getRecords();
        if (records.size() <= 0) {
            JerseyValidationUtils.respondErrorMessage((String)String.format("Configuration key %s not found", key), (Response.Status)Response.Status.NOT_FOUND);
        } else if (records.size() > 1) {
            JerseyValidationUtils.respondErrorMessage((String)String.format("Multiple configuration keys found", key), (Response.Status)Response.Status.BAD_REQUEST);
        }
        return (Configuration)records.get(0);
    }
}

