/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1.resource;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.JerseyValidationUtils;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLAccessPointConfiguration;
import at.mrdevelopment.esl.type.wrapper.element.ESLAccessPointRegistration;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationPagedResult;
import java.net.MalformedURLException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/service/accesspoint")
@Produces(value={"application/xml", "application/json"})
public class AccessPointResource {
    @Context
    private Level1Interface eslInterface;

    @GET
    public ESLAccessPointRegistrationPagedResult getRegisteredAccessPoints(@QueryParam(value="page") Integer page, @QueryParam(value="recordsPerPage") Integer recordsPerPage) {
        JerseyValidationUtils.validatePage((Integer)page);
        try {
            DatasetQuery query = this.eslInterface.getQuery("accesspointconfiguration/index");
            QueryResult queryResult = this.eslInterface.executeQuery(query, QueryRestriction.newQuery((Integer)page, (Integer)recordsPerPage, (int)Config.getRecordsPerPage()));
            return ESLAccessPointRegistration.wrap((QueryResult)queryResult);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MappingException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    public void registerAccessPoint(ESLAccessPointRegistration accessPointRegistration) {
        JerseyValidationUtils.validateNotNull((Object)accessPointRegistration);
        try {
            this.eslInterface.registerAccessPoint(accessPointRegistration.toAccessPointRegistration());
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (MalformedURLException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{accessPointId}")
    public void updateAccessPointConfiguration(@PathParam(value="accessPointId") int accessPointId, ESLAccessPointConfiguration accessPointConfiguration) {
        JerseyValidationUtils.validateAccessPointId((int)accessPointId);
        JerseyValidationUtils.validateNotNull((Object)accessPointConfiguration);
        try {
            this.eslInterface.updateAccessPointConfiguration(accessPointId, accessPointConfiguration.toAccessPointRegistrationConfiguration());
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{accessPointId}")
    public void unregisterAccessPoint(@PathParam(value="accessPointId") int accessPointId) {
        JerseyValidationUtils.validateAccessPointId((int)accessPointId);
        try {
            this.eslInterface.unregisterAccessPoint(accessPointId);
        }
        catch (DatasetException exc) {
            throw JerseyValidationUtils.createException((Throwable)exc, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

