/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.level1;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelEventStorage {
    public final LinkedHashMap<UUID, LabelEvent> labelEvents = new LinkedHashMap(4096);

    public synchronized List<LabelEvent> getLabelEvents() {
        return Lists.newArrayList(this.labelEvents.values());
    }

    public synchronized List<LabelEvent> getLabelEvents(LabelId labelId) {
        final long address = labelId.toAddress().getHardwareAddress();
        return Lists.newArrayList((Iterable)Collections2.filter(this.labelEvents.values(), (Predicate)new Predicate<LabelEvent>(){

            public boolean apply(LabelEvent event) {
                return event.getLabelAddress().getHardwareAddress() == address;
            }
        }));
    }

    public synchronized List<LabelEvent> getLabelEvents(Integer page, int recordsPerPage) {
        ArrayList<LabelEvent> results = new ArrayList<LabelEvent>();
        if (page < 0 || recordsPerPage < 0) {
            return results;
        }
        int currentPage = 0;
        int recordCount = 0;
        for (LabelEvent event : this.labelEvents.values()) {
            if (currentPage == page) {
                if (results.size() >= recordsPerPage) {
                    return results;
                }
                results.add(new LabelEvent(event));
                continue;
            }
            if (++recordCount < recordsPerPage) continue;
            ++currentPage;
            recordCount = 0;
        }
        return results;
    }

    public synchronized List<LabelEvent> getLabelEvents(int page, int recordsPerPage, LabelId labelId) {
        long address = labelId.toAddress().getHardwareAddress();
        ArrayList<LabelEvent> results = new ArrayList<LabelEvent>();
        if (page < 0 || recordsPerPage < 0) {
            return results;
        }
        int currentPage = 0;
        int recordCount = 0;
        for (LabelEvent event : this.labelEvents.values()) {
            if (event.getLabelAddress().getHardwareAddress() != address) continue;
            if (currentPage == page) {
                if (results.size() >= recordsPerPage) {
                    return results;
                }
                results.add(new LabelEvent(event));
                continue;
            }
            if (++recordCount < recordsPerPage) continue;
            ++currentPage;
            recordCount = 0;
        }
        return results;
    }

    public synchronized int getRecordCount() {
        return this.labelEvents.size();
    }

    public synchronized int getRecordCount(LabelId labelId) {
        long address = labelId.toAddress().getHardwareAddress();
        int recordCount = 0;
        for (LabelEvent event : this.labelEvents.values()) {
            if (event.getLabelAddress().getHardwareAddress() != address) continue;
            ++recordCount;
        }
        return recordCount;
    }

    public synchronized void addEvent(LabelEvent newEvent) {
        LabelEvent oldEvent = this.labelEvents.get(newEvent.getEventId());
        if (oldEvent != null) {
            oldEvent.takeDataFrom(newEvent);
        } else {
            this.labelEvents.put(newEvent.getEventId(), newEvent);
        }
    }

    public synchronized void cleanup() {
        Iterator<LabelEvent> iterator = this.labelEvents.values().iterator();
        DateTime now = DateTime.now();
        while (iterator.hasNext()) {
            LabelEvent labelEvent = iterator.next();
            if (!labelEvent.getReceivedTime().plusHours(24).isBefore((ReadableInstant)now)) continue;
            iterator.remove();
        }
    }
}

