/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.jersey.configuration;

import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.toolkit.InitializationException;

public class JerseyConfiguration {
    private static final String CONFIGURATION_KEY_ALLOW_ALL_ORIGINS = "pluginJerseyAllowAllOrigins";
    private static final boolean DEFAULT_ALLOW_ALL_ORIGINS = false;
    private final boolean allowAllOrigins;

    public JerseyConfiguration(Level1Interface eslInterface) throws InitializationException {
        try {
            Transaction transaction = eslInterface.getTransactionSupplier().newTransaction();
            try {
                this.allowAllOrigins = eslInterface.getPluginConfiguration().getBoolean(CONFIGURATION_KEY_ALLOW_ALL_ORIGINS, false, transaction);
                transaction.commit();
            }
            catch (DatasetException exc) {
                transaction.rollback();
                throw new InitializationException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public boolean isAllowAllOrigins() {
        return this.allowAllOrigins;
    }
}

