/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.webcam;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.Image;
import com.lti.civil.awt.AWTImageConverter;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoreMostRecent_CaptureObserver
implements CaptureObserver {
    private static final Logger logger = Logger.global;
    private byte[] bytes;

    public void onNewImage(CaptureStream sender, Image image) {
        if (image == null) {
            this.bytes = null;
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JPEGImageEncoder jpeg = JPEGCodec.createJPEGEncoder((OutputStream)os);
            jpeg.encode(AWTImageConverter.toBufferedImage(image));
            os.close();
            this.bytes = os.toByteArray();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.bytes = null;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "" + t, t);
            this.bytes = null;
        }
    }

    public void onError(CaptureStream sender, CaptureException e) {
        logger.log(Level.WARNING, "" + e, e);
        this.bytes = null;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

