/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.test;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.VideoFormat;
import com.lti.civil.test.MyCaptureObserver;
import java.util.List;

public class CaptureSystemTest {
    public static void main(String[] args) throws CaptureException {
        CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
        CaptureSystem system = factory.createCaptureSystem();
        system.init();
        List list = system.getCaptureDeviceInfoList();
        for (int i = 0; i < list.size(); ++i) {
            CaptureDeviceInfo info = (CaptureDeviceInfo)list.get(i);
            System.out.println("Device ID " + i + ": " + info.getDeviceID());
            System.out.println("Description " + i + ": " + info.getDescription());
            CaptureStream captureStream = system.openCaptureDeviceStream(info.getDeviceID());
            System.out.println("Current format " + CaptureSystemTest.videoFormatToString(captureStream.getVideoFormat()));
            captureStream.setObserver(new MyCaptureObserver());
            System.out.println("Available formats:");
            for (VideoFormat format : captureStream.enumVideoFormats()) {
                System.out.println(" " + CaptureSystemTest.videoFormatToString(format));
            }
            int MAX_FORMATS = 2;
            int count = 0;
            for (VideoFormat format : captureStream.enumVideoFormats()) {
                if (count > 2) {
                    System.out.println("Stopping after 2 formats.");
                    break;
                }
                System.out.println("Choosing format: " + CaptureSystemTest.videoFormatToString(format));
                captureStream.setVideoFormat(format);
                System.out.println("Capturing for 2 seconds...");
                captureStream.start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                captureStream.stop();
                ++count;
            }
            System.out.println("disposing stream...");
            captureStream.dispose();
        }
        System.out.println("disposing system...");
        system.dispose();
        System.out.println("done.");
    }

    public static String videoFormatToString(VideoFormat f) {
        return "Type=" + CaptureSystemTest.formatTypeToString(f.getFormatType()) + " Width=" + f.getWidth() + " Height=" + f.getHeight() + " FPS=" + f.getFPS();
    }

    private static String formatTypeToString(int f) {
        switch (f) {
            case 1: {
                return "RGB24";
            }
            case 2: {
                return "RGB32";
            }
        }
        return "" + f + " (unknown)";
    }
}

