/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.jni;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import com.lti.civil.impl.jni.Peered;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCaptureStream
extends Peered
implements CaptureStream {
    private static final Logger logger = Logger.global;
    private NativeCaptureStreamThread thread;
    private boolean started;

    public NativeCaptureStream(long ptr) {
        super(ptr);
    }

    @Override
    public synchronized native List<VideoFormat> enumVideoFormats() throws CaptureException;

    @Override
    public synchronized native void setVideoFormat(VideoFormat var1) throws CaptureException;

    @Override
    public synchronized native VideoFormat getVideoFormat() throws CaptureException;

    @Override
    public synchronized native void setObserver(CaptureObserver var1);

    @Override
    public synchronized void start() throws CaptureException {
        if (this.started) {
            return;
        }
        if (this.thread == null) {
            this.thread = new NativeCaptureStreamThread();
            this.thread.setName("NativeCaptureStreamThread " + this.getPeerPtr());
            this.thread.start();
        }
        this.nativeStart();
        this.started = true;
    }

    @Override
    public synchronized void stop() throws CaptureException {
        if (!this.started) {
            return;
        }
        this.nativeStop();
        this.started = false;
    }

    @Override
    public synchronized void dispose() throws CaptureException {
        this.nativeDispose();
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }

    private synchronized native void nativeStart() throws CaptureException;

    private synchronized native void nativeStop() throws CaptureException;

    private synchronized native void nativeDispose() throws CaptureException;

    public native void threadMain();

    class NativeCaptureStreamThread
    extends Thread {
        NativeCaptureStreamThread() {
        }

        public void run() {
            logger.fine("NativeCaptureStreamThread running");
            try {
                NativeCaptureStream.this.threadMain();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "" + t, t);
            }
            logger.fine("NativeCaptureStreamThread exiting");
        }
    }
}

