/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.dummy;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import com.lti.civil.impl.common.BufferedImageImage;
import com.lti.civil.impl.common.VideoFormatImpl;
import com.lti.utils.synchronization.CloseableThread;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyCaptureStream
implements CaptureStream {
    private static final int WIDTH = 320;
    private static final int HEIGHT = 240;
    private static final int FPS = 15;
    private static final Logger logger = Logger.global;
    private GrabberThread thread;
    private CaptureObserver observer;
    private final DateFormat df = new SimpleDateFormat("M/d/yyyy HH:mm:ss.SSS");
    int fileIndex;

    @Override
    public List<VideoFormat> enumVideoFormats() throws CaptureException {
        ArrayList<VideoFormat> result = new ArrayList<VideoFormat>();
        result.add(new VideoFormatImpl(1, 320, 240, -1.0f));
        return result;
    }

    @Override
    public VideoFormat getVideoFormat() throws CaptureException {
        return this.enumVideoFormats().get(0);
    }

    @Override
    public void setVideoFormat(VideoFormat f) throws CaptureException {
    }

    @Override
    public void setObserver(CaptureObserver observer) {
        this.observer = observer;
    }

    @Override
    public void start() throws CaptureException {
        if (this.thread == null) {
            this.thread = new GrabberThread();
            this.thread.start();
        }
    }

    @Override
    public void stop() throws CaptureException {
    }

    @Override
    public void dispose() throws CaptureException {
        if (this.thread != null) {
            this.thread.close();
        }
    }

    class GrabberThread
    extends CloseableThread {
        public GrabberThread() {
            super(Thread.currentThread().getThreadGroup(), "GrabberThread");
        }

        public void close() {
            this.setClosing();
        }

        public void run() {
            while (!this.isClosing()) {
                int width = 320;
                int height = 240;
                BufferedImage buffImg = new BufferedImage(320, 240, 5);
                Date d = new Date();
                Graphics2D g = buffImg.createGraphics();
                g.setColor(Color.RED);
                g.setFont(new Font("Verdana", 1, 16));
                g.drawString(DummyCaptureStream.this.df.format(d), 10, 25);
                if (DummyCaptureStream.this.observer != null) {
                    DummyCaptureStream.this.observer.onNewImage(DummyCaptureStream.this, new BufferedImageImage(buffImg, d.getTime()));
                }
                try {
                    Thread.sleep(66L);
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
            this.setClosed();
        }
    }
}

