/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.awt;

import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class AWTImageConverter {
    public static BufferedImage toBufferedImage(Image image) {
        VideoFormat format = image.getFormat();
        int w = format.getWidth();
        int h = format.getHeight();
        byte[] bytes = image.getBytes();
        if (format.getFormatType() == 1) {
            DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
            ComponentSampleModel sm = new ComponentSampleModel(0, w, h, 3, w * 3, new int[]{2, 1, 0});
            WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
            BufferedImage bi = new BufferedImage(colorModel, r, false, null);
            return bi;
        }
        if (format.getFormatType() == 2) {
            DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
            ComponentSampleModel sm = new ComponentSampleModel(0, w, h, 4, w * 4, new int[]{2, 1, 0, 3});
            WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8, 8};
            ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
            BufferedImage bi = new BufferedImage(colorModel, r, false, null);
            return bi;
        }
        throw new IllegalArgumentException();
    }
}

