/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version, ErrorCorrectionLevel ecLevel) {
        if (rawCodewords.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
        int totalBlocks = 0;
        Version.ECB[] ecBlockArray = ecBlocks.getECBlocks();
        int i = 0;
        while (i < ecBlockArray.length) {
            totalBlocks += ecBlockArray[i].getCount();
            ++i;
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        int j = 0;
        while (j < ecBlockArray.length) {
            Version.ECB ecBlock = ecBlockArray[j];
            int i2 = 0;
            while (i2 < ecBlock.getCount()) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
                ++i2;
            }
            ++j;
        }
        int shorterBlocksTotalCodewords = result[0].codewords.length;
        int longerBlocksStartAt = result.length - 1;
        while (longerBlocksStartAt >= 0) {
            int numCodewords = result[longerBlocksStartAt].codewords.length;
            if (numCodewords == shorterBlocksTotalCodewords) break;
            --longerBlocksStartAt;
        }
        ++longerBlocksStartAt;
        int shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        int rawCodewordsOffset = 0;
        int i3 = 0;
        while (i3 < shorterBlocksNumDataCodewords) {
            int j2 = 0;
            while (j2 < numResultBlocks) {
                result[j2].codewords[i3] = rawCodewords[rawCodewordsOffset++];
                ++j2;
            }
            ++i3;
        }
        int j3 = longerBlocksStartAt;
        while (j3 < numResultBlocks) {
            result[j3].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
            ++j3;
        }
        int max = result[0].codewords.length;
        int i4 = shorterBlocksNumDataCodewords;
        while (i4 < max) {
            int j4 = 0;
            while (j4 < numResultBlocks) {
                int iOffset = j4 < longerBlocksStartAt ? i4 : i4 + 1;
                result[j4].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
                ++j4;
            }
            ++i4;
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

