/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class CodaBarReader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCDTN";
    private static final char[] ALPHABET = "0123456789-$:/.+ABCDTN".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 37, 81, 84, 21, 26, 41, 11, 14, 26, 41};
    private static final int minCharacterLength = 6;
    private static final char[] STARTEND_ENCODING = new char[]{'E', '*', 'A', 'B', 'C', 'D', 'T', 'N'};

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws NotFoundException {
        int i;
        int lastStart;
        int[] counters;
        int[] start = CodaBarReader.findAsteriskPattern(row);
        start[1] = 0;
        int nextStart = start[1];
        int end = row.getSize();
        while (nextStart < end && !row.get(nextStart)) {
            ++nextStart;
        }
        StringBuffer result = new StringBuffer();
        do {
            counters = new int[7];
            CodaBarReader.recordPattern(row, nextStart, counters);
            char decodedChar = CodaBarReader.toNarrowWidePattern(counters);
            if (decodedChar == '!') {
                throw NotFoundException.getNotFoundInstance();
            }
            result.append(decodedChar);
            lastStart = nextStart;
            i = 0;
            while (i < counters.length) {
                nextStart += counters[i];
                ++i;
            }
            while (nextStart < end && !row.get(nextStart)) {
                ++nextStart;
            }
        } while (nextStart < end);
        int lastPatternSize = 0;
        i = 0;
        while (i < counters.length) {
            lastPatternSize += counters[i];
            ++i;
        }
        int whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        if (nextStart != end && whiteSpaceAfterEnd / 2 < lastPatternSize) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (result.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        char startchar = result.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, startchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        int k = 1;
        while (k < result.length()) {
            if (result.charAt(k) == startchar && k + 1 != result.length()) {
                result.delete(k + 1, result.length() - 1);
                k = result.length();
            }
            ++k;
        }
        if (result.length() <= 6) {
            throw NotFoundException.getNotFoundInstance();
        }
        result.deleteCharAt(result.length() - 1);
        result.deleteCharAt(0);
        float left = (float)(start[1] + start[0]) / 2.0f;
        float right = (float)(nextStart + lastStart) / 2.0f;
        return new Result(result.toString(), null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODABAR);
    }

    private static int[] findAsteriskPattern(BitArray row) throws NotFoundException {
        int width = row.getSize();
        int rowOffset = 0;
        while (rowOffset < width) {
            if (row.get(rowOffset)) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int[] counters = new int[7];
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        int i = rowOffset;
        while (i < width) {
            boolean pixel = row.get(i);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == patternLength - 1) {
                    try {
                        if (CodaBarReader.arrayContains(STARTEND_ENCODING, CodaBarReader.toNarrowWidePattern(counters)) && row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                            return new int[]{patternStart, i};
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    patternStart += counters[0] + counters[1];
                    int y = 2;
                    while (y < patternLength) {
                        counters[y - 2] = counters[y];
                        ++y;
                    }
                    counters[patternLength - 2] = 0;
                    counters[patternLength - 1] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite ^= true;
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean arrayContains(char[] array, char key) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static char toNarrowWidePattern(int[] counters) {
        int numCounters = counters.length;
        int maxNarrowCounter = 0;
        int minCounter = Integer.MAX_VALUE;
        int i = 0;
        while (i < numCounters) {
            if (counters[i] < minCounter) {
                minCounter = counters[i];
            }
            if (counters[i] > maxNarrowCounter) {
                maxNarrowCounter = counters[i];
            }
            ++i;
        }
        do {
            int wideCounters = 0;
            int pattern = 0;
            int i2 = 0;
            while (i2 < numCounters) {
                if (counters[i2] > maxNarrowCounter) {
                    pattern |= 1 << numCounters - 1 - i2;
                    ++wideCounters;
                }
                ++i2;
            }
            if (wideCounters != 2 && wideCounters != 3) continue;
            i2 = 0;
            while (i2 < CHARACTER_ENCODINGS.length) {
                if (CHARACTER_ENCODINGS[i2] == pattern) {
                    return ALPHABET[i2];
                }
                ++i2;
            }
        } while (--maxNarrowCounter > minCounter);
        return '!';
    }
}

